/*
 * Decompiled with CFR 0.152.
 */
package fr.joschma.BlockParty.Cuboid;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class Cuboid {
    private final int xMin;
    private final int xMax;
    private final int yMin;
    private final int yMax;
    private final int zMin;
    private final int zMax;
    private final double xMinCentered;
    private final double xMaxCentered;
    private final double yMinCentered;
    private final double yMaxCentered;
    private final double zMinCentered;
    private final double zMaxCentered;
    private final World world;

    public Cuboid(Location point1, Location point2) {
        this.xMin = Math.min(point1.getBlockX(), point2.getBlockX());
        this.xMax = Math.max(point1.getBlockX(), point2.getBlockX());
        this.yMin = Math.min(point1.getBlockY(), point2.getBlockY());
        this.yMax = Math.max(point1.getBlockY(), point2.getBlockY());
        this.zMin = Math.min(point1.getBlockZ(), point2.getBlockZ());
        this.zMax = Math.max(point1.getBlockZ(), point2.getBlockZ());
        this.world = point1.getWorld();
        this.xMinCentered = (double)this.xMin + 0.5;
        this.xMaxCentered = (double)this.xMax + 0.5;
        this.yMinCentered = (double)this.yMin + 0.5;
        this.yMaxCentered = (double)this.yMax + 0.5;
        this.zMinCentered = (double)this.zMin + 0.5;
        this.zMaxCentered = (double)this.zMax + 0.5;
    }

    public Location getMinBlock() {
        return new Location(this.getPoint1().getWorld(), (double)this.xMin, (double)this.yMin, (double)this.zMin);
    }

    public Location getMaxBlock() {
        return new Location(this.getPoint2().getWorld(), (double)this.xMax, (double)this.yMax, (double)this.zMax);
    }

    public double getHighestY() {
        if (this.getPoint1() == null || this.getPoint2() == null) {
            return 0.0;
        }
        if (this.getPoint1().getY() >= this.getPoint2().getY()) {
            return this.getPoint1().getY();
        }
        return this.getPoint2().getY();
    }

    public double getLowestY() {
        if (this.getPoint1() == null || this.getPoint2() == null) {
            return 0.0;
        }
        if (this.getPoint1().getY() <= this.getPoint2().getY()) {
            return this.getPoint1().getY();
        }
        return this.getPoint2().getY();
    }

    public ArrayList<Block> blockList() {
        ArrayList<Block> bL = new ArrayList<Block>(this.getTotalBlockSize());
        for (int x = this.xMin; x <= this.xMax; ++x) {
            for (int y = this.yMin; y <= this.yMax; ++y) {
                for (int z = this.zMin; z <= this.zMax; ++z) {
                    Block b = this.world.getBlockAt(x, y, z);
                    bL.add(b);
                    bL.iterator();
                }
            }
        }
        return bL;
    }

    public Location getCenter() {
        return new Location(this.world, (double)((this.xMax - this.xMin) / 2 + this.xMin), (double)((this.yMax - this.yMin) / 2 + this.yMin), (double)((this.zMax - this.zMin) / 2 + this.zMin));
    }

    public double getDistance() {
        return this.getPoint1().distance(this.getPoint2());
    }

    public double getDistanceSquared() {
        return this.getPoint1().distanceSquared(this.getPoint2());
    }

    public int getHeight() {
        return this.yMax - this.yMin + 1;
    }

    public Location getPoint1() {
        return new Location(this.world, (double)this.xMin, (double)this.yMin, (double)this.zMin);
    }

    public Location getPoint2() {
        return new Location(this.world, (double)this.xMax, (double)this.yMax, (double)this.zMax);
    }

    public Location getRandomLocation() {
        Random rand = new Random();
        int x = rand.nextInt(Math.abs(this.xMax - this.xMin) + 1) + this.xMin;
        int y = rand.nextInt(Math.abs(this.yMax - this.yMin) + 1) + this.yMin;
        int z = rand.nextInt(Math.abs(this.zMax - this.zMin) + 1) + this.zMin;
        return new Location(this.world, (double)x, (double)y, (double)z);
    }

    public int getTotalBlockSize() {
        return this.getHeight() * this.getXWidth() * this.getZWidth();
    }

    public int getXWidth() {
        return this.xMax - this.xMin + 1;
    }

    public int getZWidth() {
        return this.zMax - this.zMin + 1;
    }

    public boolean isIn(Location loc) {
        return loc.getWorld() == this.world && loc.getBlockX() >= this.xMin && loc.getBlockX() <= this.xMax && loc.getBlockY() >= this.yMin && loc.getBlockY() <= this.yMax && loc.getBlockZ() >= this.zMin && loc.getBlockZ() <= this.zMax;
    }

    public boolean isIn(Player player) {
        return this.isIn(player.getLocation());
    }

    public boolean isInWithMarge(Location loc, double marge) {
        return loc.getWorld() == this.world && loc.getX() >= this.xMinCentered - marge && loc.getX() <= this.xMaxCentered + marge && loc.getY() >= this.yMinCentered - marge && loc.getY() <= this.yMaxCentered + marge && loc.getZ() >= this.zMinCentered - marge && loc.getZ() <= this.zMaxCentered + marge;
    }
}

