/*
 * Decompiled with CFR 0.152.
 */
package fr.joschma.BlockParty.Manager;

import com.craftmend.openaudiomc.api.ClientApi;
import com.craftmend.openaudiomc.api.MediaApi;
import com.craftmend.openaudiomc.api.clients.Client;
import com.craftmend.openaudiomc.api.media.Media;
import com.xxmicloxx.NoteBlockAPI.model.Playlist;
import com.xxmicloxx.NoteBlockAPI.model.RepeatMode;
import com.xxmicloxx.NoteBlockAPI.model.Song;
import com.xxmicloxx.NoteBlockAPI.songplayer.RadioSongPlayer;
import com.xxmicloxx.NoteBlockAPI.utils.NBSDecoder;
import fr.joschma.BlockParty.Arena.Arena;
import fr.joschma.BlockParty.Arena.State.SongProvider;
import fr.joschma.BlockParty.Arena.State.SongSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.mcjukebox.plugin.bukkit.api.JukeboxAPI;
import net.mcjukebox.plugin.bukkit.api.ResourceType;
import org.bukkit.entity.Player;

public class MusicManager {
    public void startMusic(Arena a) {
        block4: {
            block5: {
                block3: {
                    if (a.getSongProvider() != SongProvider.NoteBlock) break block3;
                    if (!a.isPlayMusic()) break block4;
                    a.getRadioSongPlayer().setPlaying(true);
                    a.getRadioSongPlayer().setVolume((byte)a.getVolumeNoteBlock());
                    break block4;
                }
                if (a.getSongProvider() != SongProvider.MCJukebox) break block5;
                if (!a.isPlayMusic()) break block4;
                for (Player p : a.getPlayers()) {
                    JukeboxAPI.play((Player)p, (net.mcjukebox.plugin.bukkit.api.models.Media)a.getMcJukeboxSong());
                }
                break block4;
            }
            if (a.getSongProvider() == SongProvider.OpenAudioMC) {
                Random rand = new Random();
                int i = rand.nextInt(a.getOpenAudioMusic().keySet().size());
                String music = (String)a.getOpenAudioMusic().keySet().toArray()[i];
                Media sound = new Media(a.getOpenAudioMusic().get(music));
                sound.setLoop(true);
                sound.setVolume(50);
                sound.setMediaId("BlockParty");
                for (Player p : a.getPlayers()) {
                    ClientApi.getInstance().getClient(p.getUniqueId()).playMedia(sound);
                }
            }
        }
    }

    public void startStopMusic(Arena a) {
        block4: {
            block5: {
                block3: {
                    if (a.getSongProvider() != SongProvider.NoteBlock) break block3;
                    if (!a.isPlayStopMusic()) break block4;
                    this.loadStopRadioSongPlayer(a);
                    break block4;
                }
                if (a.getSongProvider() != SongProvider.MCJukebox) break block5;
                if (!a.isPlayStopMusic()) break block4;
                for (Player p : a.getPlayers()) {
                    JukeboxAPI.play((Player)p, (net.mcjukebox.plugin.bukkit.api.models.Media)a.getMcJukeboxStopSong());
                }
                break block4;
            }
            if (a.getSongProvider() == SongProvider.OpenAudioMC) {
                Media sound = new Media(a.getOpenAudioStopMusic());
                sound.setLoop(true);
                sound.setVolume(50);
                sound.setMediaId("BlockPartyStop");
                for (Player p : a.getPlayers()) {
                    ClientApi.getInstance().getClient(p.getUniqueId()).playMedia(sound);
                }
            }
        }
    }

    public void stopMusic(Arena a) {
        block2: {
            block4: {
                block3: {
                    if (!a.isPlayMusic()) break block2;
                    if (a.getSongProvider() != SongProvider.NoteBlock) break block3;
                    a.getRadioSongPlayer().setPlaying(false);
                    break block2;
                }
                if (a.getSongProvider() != SongProvider.MCJukebox) break block4;
                for (Player p : a.getPlayers()) {
                    JukeboxAPI.stopMusic((Player)p);
                }
                break block2;
            }
            if (a.getSongProvider() != SongProvider.OpenAudioMC) break block2;
            for (Player p : a.getPlayers()) {
                MediaApi.getInstance().stopFor("BlockParty", new Client[]{ClientApi.getInstance().getClient(p.getUniqueId())});
            }
        }
    }

    public void stopStopMusic(Arena a) {
        block5: {
            block6: {
                if (!a.isPlayStopMusic()) break block5;
                if (a.getSongProvider() != SongProvider.NoteBlock) break block6;
                if (a.getRadioStopSongPlayer() == null) break block5;
                a.getRadioStopSongPlayer().setPlaying(false);
                a.getRadioStopSongPlayer().destroy();
                break block5;
            }
            if (a.getSongProvider() == SongProvider.MCJukebox) {
                for (Player p : a.getPlayers()) {
                    JukeboxAPI.stopMusic((Player)p);
                }
            } else if (a.getSongProvider() == SongProvider.OpenAudioMC) {
                for (Player p : a.getPlayers()) {
                    MediaApi.getInstance().stopFor("BlockPartyStop", new Client[]{ClientApi.getInstance().getClient(p.getUniqueId())});
                }
            }
        }
    }

    public void stopMcJukeboxMusic(Player p) {
        JukeboxAPI.stopMusic((Player)p);
    }

    public void setUpMusics(Arena a) {
        if (a.getSongProvider() == SongProvider.NoteBlock) {
            if (a.getPl().isNoteIsEnable()) {
                this.createSongs(a);
                this.createStopSong(a);
                if (a.getSongs() != null && a.getSongs().length > 0) {
                    if (a.getSongSetting() == SongSetting.RANDOM) {
                        this.loadRandomSongPlayer(a);
                        a.setPlayMusic(true);
                    } else {
                        a.setPlayMusic(true);
                        if (a.getSongManager().getNumberOfVoteMap().values().size() > 0) {
                            Map.Entry<String, Integer> entry = this.sortByValue(a.getSongManager().getNumberOfVoteMap()).entrySet().iterator().next();
                            String key = entry.getKey();
                            a.setChosenSong(this.createChosenSong(a, key));
                        } else {
                            Random rand = new Random();
                            a.setChosenSong(a.getSongs()[rand.nextInt(a.getSongs().length)]);
                        }
                        if (a.getChosenSong() != null) {
                            this.loadChoseSongPlayer(a);
                        } else {
                            for (Player p : a.getPlayers()) {
                                a.getPl().getDebug().error(p, "No sound found !");
                                a.setPlayMusic(false);
                            }
                        }
                    }
                } else {
                    for (Player p : a.getPlayers()) {
                        a.getPl().getDebug().error(p, "No sound found. Try to check the music path");
                        a.setPlayMusic(false);
                    }
                }
                if (a.getStopSong() != null) {
                    a.setPlayStopMusic(true);
                }
            } else {
                a.getPl().getDebug().broadcastError(" *** NoteBlockAPI is not installed or not enabled. ***");
                a.getPl().getDebug().broadcastError("https://www.spigotmc.org/resources/noteblockapi.19287/");
            }
        } else if (a.getSongProvider() == SongProvider.MCJukebox) {
            if (a.getPl().isMCJukeboxIsEnable()) {
                a.setPlayMusic(true);
                this.loadMcJuckboxStopSong(a);
                String url = "";
                if (a.getSongSetting() == SongSetting.RANDOM || a.getSongManager().getNumberOfVoteMap().isEmpty()) {
                    Random rand = new Random();
                    int randNumb = rand.nextInt(a.getLinkToMusic().keySet().size());
                    url = a.getLinkToMusic().get(a.getLinkToMusic().keySet().toArray()[randNumb]);
                } else {
                    Map.Entry<String, Integer> entry = this.sortByValue(a.getSongManager().getNumberOfVoteMap()).entrySet().iterator().next();
                    String key = entry.getKey();
                    if (a.getLinkToMusic().containsKey(key)) {
                        url = a.getLinkToMusic().get(key);
                    } else {
                        for (Player p : a.getPlayers()) {
                            a.getPl().getDebug().error(p, key + " not found ! Stopping game");
                        }
                        a.urgentLeaveGame();
                        a.setPlayMusic(false);
                        return;
                    }
                }
                this.loadMcJuckboxSong(a, url);
            } else {
                a.setPlayMusic(false);
                a.getPl().getDebug().broadcastError(" *** MCJukebox is not installed or not enabled. ***");
                a.getPl().getDebug().broadcastError("https://www.spigotmc.org/resources/mcjukebox.16024/");
            }
        } else if (a.getSongProvider() == SongProvider.OpenAudioMC) {
            a.setPlayMusic(true);
            this.startMusic(a);
        }
    }

    public void loadMcJuckboxSong(Arena a, String url) {
        net.mcjukebox.plugin.bukkit.api.models.Media media = new net.mcjukebox.plugin.bukkit.api.models.Media(ResourceType.MUSIC, url);
        media.setLooping(true);
        media.setFadeDuration(0);
        a.setMcJukeboxSong(media);
        a.setPlayMusic(true);
        this.startMusic(a);
    }

    public void loadMcJuckboxStopSong(Arena a) {
        net.mcjukebox.plugin.bukkit.api.models.Media media = new net.mcjukebox.plugin.bukkit.api.models.Media(ResourceType.MUSIC, a.getLinkToStopMusic());
        media.setLooping(false);
        media.setFadeDuration(0);
        a.setMcJukeboxStopSong(media);
        a.setPlayStopMusic(true);
    }

    public void loadStopRadioSongPlayer(Arena a) {
        if (a.isPlayStopMusic()) {
            RadioSongPlayer rsp = null;
            try {
                new RadioSongPlayer(a.getStopSong());
                rsp = new RadioSongPlayer(a.getStopSong());
                for (Player p : a.getPlayers()) {
                    rsp.addPlayer(p);
                }
                rsp.setVolume((byte)a.getVolumeNoteBlock());
                rsp.setPlaying(true);
            }
            catch (Exception e) {
                a.getPl().getDebug().sysout("Stop song is corrupted !");
            }
            a.setRadioStopSongPlayer(rsp);
        }
    }

    private void loadRandomSongPlayer(Arena a) {
        Playlist playlist = new Playlist(a.getSongs());
        RadioSongPlayer rsp = new RadioSongPlayer(playlist);
        rsp.setRepeatMode(RepeatMode.ALL);
        rsp.setRandom(true);
        for (Player p : a.getPlayers()) {
            rsp.addPlayer(p);
        }
        rsp.setPlaying(true);
        a.setRadioSongPlayer(rsp);
        this.startMusic(a);
    }

    private void loadChoseSongPlayer(Arena a) {
        RadioSongPlayer rsp = new RadioSongPlayer(a.getChosenSong());
        rsp.setRepeatMode(RepeatMode.ALL);
        for (Player p : a.getPlayers()) {
            rsp.addPlayer(p);
        }
        rsp.setPlaying(true);
        a.setRadioSongPlayer(rsp);
        this.startMusic(a);
    }

    private Song createChosenSong(Arena a, String musicName) {
        String pathToMusic = "";
        for (String path : a.getPathToMusic()) {
            if (!path.contains(musicName + ".nbs")) continue;
            pathToMusic = path;
        }
        return NBSDecoder.parse((File)new File(a.getPl().getDataFolder(), pathToMusic));
    }

    private void createStopSong(Arena a) {
        String pathToMusic = "";
        pathToMusic = a.getPathToStopMusic().contains("/") ? a.getPathToStopMusic().replace("/", File.separator) : (a.getPathToStopMusic().contains("\\") ? a.getPathToStopMusic().replace("\\", File.separator) : a.getPathToStopMusic());
        if (new File(a.getPl().getDataFolder(), pathToMusic) != null && new File(a.getPl().getDataFolder(), pathToMusic).exists() && new File(a.getPl().getDataFolder(), pathToMusic).isFile()) {
            Song stopSong = NBSDecoder.parse((File)new File(a.getPl().getDataFolder(), pathToMusic));
            a.setStopSong(stopSong);
        }
    }

    private void createSongs(Arena a) {
        ArrayList<Song> songs = new ArrayList<Song>();
        for (int i = 0; i < a.getPathToMusic().size(); ++i) {
            Song song;
            String pathToMusic = "";
            pathToMusic = a.getPathToMusic().get(i).contains("/") ? a.getPathToMusic().get(i).replace("/", File.separator) : (a.getPathToMusic().get(i).contains("\\") ? a.getPathToMusic().get(i).replace("\\", File.separator) : a.getPathToMusic().get(i));
            if (new File(a.getPl().getDataFolder(), pathToMusic) == null || !new File(a.getPl().getDataFolder(), pathToMusic).exists() || !new File(a.getPl().getDataFolder(), pathToMusic).isFile() || (song = NBSDecoder.parse((File)new File(a.getPl().getDataFolder(), pathToMusic))) == null) continue;
            songs.add(song);
        }
        Song[] array = new Song[songs.size()];
        songs.toArray(array);
        a.setSongs(array);
    }

    private <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> sortedEntries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(sortedEntries, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                return ((Comparable)e2.getValue()).compareTo(e1.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : sortedEntries) {
            result.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return result;
    }
}

