/*
 * Decompiled with CFR 0.152.
 */
package fr.joschma.BlockParty.Utils;

import fr.joschma.BlockParty.Arena.Arena;
import fr.joschma.BlockParty.Arena.CreateArena;
import fr.joschma.BlockParty.BPM;
import fr.joschma.BlockParty.Manager.FileManager;
import fr.joschma.BlockParty.Messages.Language;
import java.io.File;
import java.util.HashMap;
import org.bukkit.configuration.file.YamlConfiguration;

public class UtilsConfig {
    CreateArena createArena;
    BPM pl;

    public UtilsConfig(BPM pl) {
        this.pl = pl;
        this.createArena = new CreateArena(pl);
    }

    public void update() {
        this.updateArenas();
        this.updateLanguage();
        this.pl.getConfig().set("LastVersion", (Object)Double.valueOf(this.pl.getDescription().getVersion()));
        this.pl.saveConfig();
    }

    private void updateLanguage() {
        HashMap<Language.MSG, String> languageMap = new HashMap<Language.MSG, String>();
        for (Language.MSG c : Language.MSG.values()) {
            if (c == null) continue;
            languageMap.put(c, c.msg());
        }
        this.pl.saveResource("Language.yml", true);
        File file = new File(this.pl.getDataFolder(), "Language.yml");
        YamlConfiguration fc = YamlConfiguration.loadConfiguration((File)file);
        for (Language.MSG msg : languageMap.keySet()) {
            fc.set(msg.toString(), languageMap.get((Object)msg));
        }
        FileManager.save(file, fc);
    }

    private void updateArenas() {
        this.pl.getDebug().broadcastError("Updating the plugin!");
        Arena arenaTemp = this.createArena.createArena("TemporaryArenaToNeededToRectifyAPluginIssue");
        File file = arenaTemp.getFile();
        FileManager.createArenaFile(arenaTemp.getName());
        YamlConfiguration fcTemp = YamlConfiguration.loadConfiguration((File)file);
        for (Arena a : this.pl.getAm().getArenas()) {
            if (a.getName() == "TemporaryArenaToNeededToRectifyAPluginIssue") continue;
            YamlConfiguration fc = YamlConfiguration.loadConfiguration((File)a.getFile());
            for (String key : fcTemp.getConfigurationSection("").getKeys(true)) {
                if (fc.get(key) != null) continue;
                fc.set(key, fcTemp.get(key));
            }
            FileManager.save(a.getFile(), fc);
        }
        this.pl.getAm().rmvArenaListNFile(arenaTemp);
    }
}

