/*
 * Decompiled with CFR 0.152.
 */
package fr.joschma.BlockParty.Arena;

import com.alessiodp.parties.api.Parties;
import com.alessiodp.parties.api.interfaces.PartiesAPI;
import com.alessiodp.parties.api.interfaces.Party;
import com.alessiodp.parties.api.interfaces.PartyPlayer;
import com.craftmend.openaudiomc.api.ClientApi;
import com.craftmend.openaudiomc.api.MediaApi;
import com.craftmend.openaudiomc.api.clients.Client;
import com.cryptomorin.xseries.XMaterial;
import com.xxmicloxx.NoteBlockAPI.model.Song;
import com.xxmicloxx.NoteBlockAPI.songplayer.RadioSongPlayer;
import fr.joschma.BlockParty.Arena.End.End;
import fr.joschma.BlockParty.Arena.JoinArena.JoinArena;
import fr.joschma.BlockParty.Arena.Round;
import fr.joschma.BlockParty.Arena.StartGame;
import fr.joschma.BlockParty.Arena.State.ArenaState;
import fr.joschma.BlockParty.Arena.State.ParticleColourSetting;
import fr.joschma.BlockParty.Arena.State.SongProvider;
import fr.joschma.BlockParty.Arena.State.SongSetting;
import fr.joschma.BlockParty.Arena.Timer.AppreciateTime;
import fr.joschma.BlockParty.Arena.Timer.GiveTerracotaTimer;
import fr.joschma.BlockParty.Arena.Timer.RegenerateBlockTimer;
import fr.joschma.BlockParty.Arena.Timer.RemoveFloorCountDown;
import fr.joschma.BlockParty.Arena.Timer.WaitLobbyTimer;
import fr.joschma.BlockParty.BPM;
import fr.joschma.BlockParty.Cuboid.Cuboid;
import fr.joschma.BlockParty.Cuboid.DistributedFiller;
import fr.joschma.BlockParty.Cuboid.WorkloadRunnable;
import fr.joschma.BlockParty.Manager.FileManager;
import fr.joschma.BlockParty.Manager.SongManager;
import fr.joschma.BlockParty.Messages.Language;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.mcjukebox.plugin.bukkit.api.models.Media;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class Arena {
    BPM pl;
    SongProvider songProvider;
    SongManager songManager;
    String name;
    String powerUpName;
    File file;
    ArenaState state;
    SongSetting songSetting;
    GameMode gmOnDeath;
    boolean powerUpAsBlock;
    boolean giveBlock;
    boolean giveDye;
    boolean resetExp;
    boolean giveSlimeBall;
    boolean clearInventory;
    boolean saveInventory;
    boolean finished;
    boolean playMusic;
    boolean playStopMusic;
    boolean playerColision;
    boolean changeTime;
    boolean allowPVP;
    boolean enableLightnings;
    boolean enableFireworksOnWin;
    boolean enableScoreboard;
    boolean autoRestart;
    boolean enablePowerUps;
    boolean allowJoinDuringGame;
    boolean onlyCustomFloors;
    boolean randomizeCustomFloor;
    boolean colourGroup;
    boolean soloGame;
    boolean nightVision;
    boolean noTitleBar;
    boolean showColorNameInBarTitle;
    boolean smartRandomJoin;
    boolean useSameColourGroup;
    boolean useParticles;
    Map<Integer, List<Material>> colourGroupMap = new HashMap<Integer, List<Material>>();
    int maxPlayer;
    int minPlayer;
    int lobbyWaitTime;
    int appreciateTime;
    int regenerateBlockTime;
    int waitTimeBeforeGiveColorFirstRound;
    int waitTimeBeforeGiveColor;
    double timeToRemoveFromRemoveFloorTime;
    double removeFloorTime;
    double baseRemoveFloorTime;
    int round;
    int durationPowerUp;
    int levelOfPowerUp;
    double rangeToCatchPowerup;
    int YLevelToDie;
    int maxNumberOfRound;
    int particleCount;
    Double particleSize;
    Material danceFloorActualMaterial;
    Material powerUpHead;
    List<Material> danceFloorColourGroupActualMaterials;
    List<Material> danceFloorFloorMaterials;
    List<Integer> roundToSpawnPowerUp;
    List<Integer> roundToReduceTime;
    List<String> pathToMusic;
    String pathToStopMusic;
    Map<String, String> linkToMusic;
    String linkToStopMusic;
    List<Player> winners;
    List<Player> players;
    List<Player> playersAlive;
    List<Sign> signs;
    Location lobbySpawn;
    Location exitSpawn;
    Location powerUpLoc;
    Cuboid danceFloorCuboid;
    Map<Material, List<Location>> savedDanceFloorMaterialMap = new HashMap<Material, List<Location>>();
    Cuboid arenaCuboid;
    Song[] songs;
    Song stopSong;
    Song chosenSong;
    RadioSongPlayer radioSongPlayer;
    RadioSongPlayer radioStopSongPlayer;
    Media mcJukeboxSong;
    Media mcJukeboxStopSong;
    Map<String, String> openAudioMusic;
    String openAudioStopMusic;
    List<String> allowedCommands;
    List<String> commandsOnGameEnd;
    final StartGame startGame;
    final Round roundFile;
    final AppreciateTime appreciateTimeFile;
    final GiveTerracotaTimer giveTerracotaTimer;
    final RegenerateBlockTimer regenerateBlockTimer;
    final RemoveFloorCountDown removeFloorCountDown;
    final WaitLobbyTimer waitLobbyTimer;
    Map<String, Integer> numberOfVote;
    Map<Player, String> playerVote;
    final ItemStack pinkDye;
    final ItemStack limeDye;
    List<String> customDanceFloor;
    List<String> scoreBoard;
    List<String> powerUps;
    List<String> signDisplay;
    DistributedFiller distributedFiller;
    WorkloadRunnable workloadRunnable;
    double maxMillisSecondPerTickToGenerateArenaDanceFloor;
    Map<String, Integer> potionEffects;
    String winDanceFloor;
    String waitDanceFloor;
    GameMode gameModeOnLeave;
    Particle particle;
    Color defaultParticleColour;
    ParticleColourSetting particleColourSetting;
    String customHeadLink;
    boolean useCustomHeadLink;
    String suffix_colour;
    List<Material> excludedDanceFloorBlocks = new ArrayList<Material>();
    int VolumeNoteBlock;
    int taskID = 0;

    public Arena(BPM pl, String name, String powerUpName, File file, ArenaState state, SongSetting songSetting, boolean finished, int maxPlayer, int minPlayer, int lobbyWaitTime, int appreciateTime, int regenerateBlockTime, int waitTimeBeforeGiveColorFirstRound, int waitTimeBeforeGiveColor, double timeToRemoveFromRemoveFloorTime, double removeFloorTime, double baseRemoveFloorTime, int round, int durationPowerUp, int levelOfPowerUp, double rangeToCatchPowerup, int yLevelToDie, int maxNumberOfRound, Material powerUpHead, List<Material> danceFloorFloorMaterials, List<Integer> roundToSpawnPowerUp, List<Integer> roundToReduceTime, List<String> pathToMusic, Map<String, String> linkToMusic, String linkToStopMusic, List<Sign> signs, String pathToStopMusic, Location lobbySpawn, Location exitSpawn, Cuboid danceFloorCuboid, Cuboid arenaCuboid, List<String> allowedCommands, List<String> commandsOnGameEnd, boolean playerColision, boolean changeTime, GameMode gmOnDeath, boolean saveInventory, SongProvider songProvider, boolean giveSlimeBall, boolean clearInventory, boolean giveDye, boolean resetExp, boolean giveBlock, boolean allowPVP, boolean autoRestart, boolean enableLightnings, boolean enablePowerUps, boolean enableFireworksOnWin, boolean allowJoinDuringGame, boolean enableScoreboard, List<String> customDanceFloor, boolean randomizeCustomFloor, boolean onlyCustomFloors, boolean colourGroup, boolean isNightVision, Map<String, String> openAudioMusic, String openAudioStopMusic, boolean noTitleBar, boolean showColorNameInBarTitle, boolean smartRandomJoin, List<String> scoreBoard, List<String> powerUps, double maxMillisSecondPerTickToGenerateArenaDanceFloor, List<String> signDisplay, Map<String, Integer> potionEffects, String winDanceFloor, String waitDanceFloor, boolean powerUpAsBlock, GameMode gameModeOnLeave, boolean useSameColourGroup, boolean useParticles, int particleCount, Double particleSize, Particle particle, Color defaultParticleColour, ParticleColourSetting particleColourSetting, String customHeadLink, boolean useCustomHeadLink, String suffix_colour, List<Material> excludedDanceFloorBlocks, int VolumeNoteBlock) {
        this.VolumeNoteBlock = VolumeNoteBlock;
        this.excludedDanceFloorBlocks = excludedDanceFloorBlocks;
        this.suffix_colour = suffix_colour;
        this.useCustomHeadLink = useCustomHeadLink;
        this.customHeadLink = customHeadLink;
        this.particleColourSetting = particleColourSetting;
        this.defaultParticleColour = defaultParticleColour;
        this.particle = particle;
        this.particleSize = particleSize;
        this.particleCount = particleCount;
        this.useParticles = useParticles;
        this.gameModeOnLeave = gameModeOnLeave;
        this.powerUpAsBlock = powerUpAsBlock;
        this.winDanceFloor = winDanceFloor;
        this.waitDanceFloor = waitDanceFloor;
        this.potionEffects = potionEffects;
        this.signDisplay = signDisplay;
        this.powerUps = powerUps;
        this.scoreBoard = scoreBoard;
        this.smartRandomJoin = smartRandomJoin;
        this.showColorNameInBarTitle = showColorNameInBarTitle;
        this.noTitleBar = noTitleBar;
        this.openAudioMusic = openAudioMusic;
        this.openAudioStopMusic = openAudioStopMusic;
        this.danceFloorColourGroupActualMaterials = new ArrayList<Material>();
        this.danceFloorFloorMaterials = new ArrayList<Material>();
        this.roundToSpawnPowerUp = new ArrayList<Integer>();
        this.roundToReduceTime = new ArrayList<Integer>();
        this.pathToMusic = new ArrayList<String>();
        this.winners = new ArrayList<Player>();
        this.players = new ArrayList<Player>();
        this.playersAlive = new ArrayList<Player>();
        this.signs = new ArrayList<Sign>();
        this.appreciateTimeFile = new AppreciateTime();
        this.giveTerracotaTimer = new GiveTerracotaTimer();
        this.regenerateBlockTimer = new RegenerateBlockTimer();
        this.removeFloorCountDown = new RemoveFloorCountDown();
        this.songManager = new SongManager(this);
        this.pl = pl;
        this.roundFile = new Round(pl);
        this.startGame = new StartGame(pl);
        this.waitLobbyTimer = new WaitLobbyTimer(this);
        this.name = name;
        this.powerUpName = powerUpName;
        this.file = file;
        this.state = state;
        this.songSetting = songSetting;
        this.finished = finished;
        this.maxPlayer = maxPlayer;
        this.minPlayer = minPlayer;
        this.lobbyWaitTime = lobbyWaitTime;
        this.appreciateTime = appreciateTime;
        this.regenerateBlockTime = regenerateBlockTime;
        this.waitTimeBeforeGiveColorFirstRound = waitTimeBeforeGiveColorFirstRound;
        this.waitTimeBeforeGiveColor = waitTimeBeforeGiveColor;
        this.timeToRemoveFromRemoveFloorTime = timeToRemoveFromRemoveFloorTime;
        this.removeFloorTime = removeFloorTime;
        this.baseRemoveFloorTime = baseRemoveFloorTime;
        this.round = round;
        this.durationPowerUp = durationPowerUp;
        this.levelOfPowerUp = levelOfPowerUp;
        this.rangeToCatchPowerup = rangeToCatchPowerup;
        this.YLevelToDie = yLevelToDie;
        this.maxNumberOfRound = maxNumberOfRound;
        this.powerUpHead = powerUpHead;
        this.signs = signs;
        this.danceFloorFloorMaterials = danceFloorFloorMaterials;
        this.roundToSpawnPowerUp = roundToSpawnPowerUp;
        this.roundToReduceTime = roundToReduceTime;
        this.pathToMusic = pathToMusic;
        this.pathToStopMusic = pathToStopMusic;
        this.lobbySpawn = lobbySpawn;
        this.exitSpawn = exitSpawn;
        this.danceFloorCuboid = danceFloorCuboid;
        this.arenaCuboid = arenaCuboid;
        this.allowedCommands = allowedCommands;
        this.commandsOnGameEnd = commandsOnGameEnd;
        this.playerColision = playerColision;
        this.linkToMusic = linkToMusic;
        this.linkToStopMusic = linkToStopMusic;
        this.changeTime = changeTime;
        this.gmOnDeath = gmOnDeath;
        this.saveInventory = saveInventory;
        this.songProvider = songProvider;
        this.giveSlimeBall = giveSlimeBall;
        this.giveDye = giveDye;
        this.resetExp = resetExp;
        this.clearInventory = clearInventory;
        this.giveBlock = giveBlock;
        this.allowPVP = allowPVP;
        this.autoRestart = autoRestart;
        this.enableLightnings = enableLightnings;
        this.enablePowerUps = enablePowerUps;
        this.enableFireworksOnWin = enableFireworksOnWin;
        this.allowJoinDuringGame = allowJoinDuringGame;
        this.enableScoreboard = enableScoreboard;
        this.customDanceFloor = customDanceFloor;
        this.onlyCustomFloors = onlyCustomFloors;
        this.randomizeCustomFloor = randomizeCustomFloor;
        this.colourGroup = colourGroup;
        this.nightVision = isNightVision;
        this.useSameColourGroup = useSameColourGroup;
        this.maxMillisSecondPerTickToGenerateArenaDanceFloor = maxMillisSecondPerTickToGenerateArenaDanceFloor;
        this.distributedFiller = new DistributedFiller();
        this.workloadRunnable = new WorkloadRunnable(this);
        Bukkit.getScheduler().runTaskTimer((Plugin)pl, (Runnable)this.workloadRunnable, 1L, 1L);
        this.playerVote = this.songManager.getPlayerVote();
        this.numberOfVote = this.songManager.getNumberOfVoteMap();
        this.pinkDye = new ItemStack(Material.PINK_DYE);
        this.limeDye = new ItemStack(Material.LIME_DYE);
    }

    public void findASetDanceFloorActualMaterial() {
        this.taskID = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.pl, new Runnable(){

            @Override
            public void run() {
                if (Arena.this.workloadRunnable.workloadDeque.poll() == null) {
                    Material ma = Arena.this.danceFloorCuboid.getRandomLocation().getBlock().getType();
                    int i = 0;
                    while (ma == Material.AIR || Arena.this.excludedDanceFloorBlocks.contains(ma)) {
                        if (i == Arena.this.danceFloorCuboid.getTotalBlockSize()) {
                            Arena.this.pl.getDebug().broadcastError("No block to give found!");
                            Arena.this.clear();
                            break;
                        }
                        ma = Arena.this.danceFloorCuboid.getRandomLocation().getBlock().getType();
                        ++i;
                    }
                    Arena.this.setDanceFloorActualMaterial(ma);
                    Bukkit.getScheduler().cancelTask(Arena.this.taskID);
                }
            }
        }, 0L, 5L);
    }

    public String msg(Player p, String message) {
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        if (BPM.getPl().isPlaceholderIsEnable()) {
            return PlaceholderAPI.setPlaceholders((Player)p, (String)message);
        }
        return message;
    }

    public String msg(String message) {
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }

    public void updateSign() {
        if (this.state != ArenaState.INGAME) {
            for (Sign sign : this.signs) {
                int y = 0;
                for (String str : this.signDisplay) {
                    if (str.contains("%")) {
                        String[] sentence;
                        for (String stri : sentence = str.split("%")) {
                            String replaced = this.pl.getExpansionManager().arenaPlaceHolder(stri, this);
                            if (replaced == null) continue;
                            str = str.replace("%" + stri + "%", replaced);
                        }
                        sign.setLine(y, this.msg(str));
                    }
                    if (this.players.size() > 0) {
                        sign.setLine(y, this.msg(this.players.get(0), str));
                    }
                    ++y;
                }
                sign.update();
            }
        } else {
            for (Sign sign : this.signs) {
                sign.setLine(2, ChatColor.RED + "In game !");
                sign.update();
            }
        }
    }

    public void clear() {
        File leaderboard = FileManager.load("Leaderboard");
        YamlConfiguration fc = FileManager.load(leaderboard);
        this.savedDanceFloorMaterialMap.clear();
        this.playMusic = false;
        this.playStopMusic = false;
        this.soloGame = false;
        this.state = ArenaState.CLEARED;
        this.pl.getMusicManager().stopMusic(this);
        for (Player player : this.players) {
            player.setGameMode(GameMode.SURVIVAL);
            if (this.clearInventory) {
                player.getInventory().clear();
            }
            this.clearPotionEffect(player);
            if (this.isEnableScoreboard()) {
                this.pl.getScoreBoardUtils().rmvScoreBoard(player);
            }
            if (this.isSaveInventory()) {
                this.pl.getInvManager().loadInventory(player);
            }
            player.teleport(this.exitSpawn);
            if (this.playerVote.keySet().contains(player)) {
                String lastVotedSong = this.playerVote.get(player);
                this.numberOfVote.put(lastVotedSong, this.numberOfVote.get(lastVotedSong) - 1);
                this.playerVote.remove(player);
                this.songManager.setPlayerSongMap(this.numberOfVote);
                this.songManager.setPlayerVote(this.playerVote);
            }
            int games = fc.getInt(player.getUniqueId() + ".game") + 1;
            fc.set(player.getUniqueId() + ".game", (Object)games);
            fc.set(player.getUniqueId() + ".name", (Object)player.getName());
            this.pl.getLeaderboardManager().getGameMap().put(player.getName(), games);
            this.pl.getLeaderboardManager().getLooseMap().put(player.getName(), games - fc.getInt(player.getUniqueId() + ".win"));
        }
        this.pl.getMusicManager().stopMusic(this);
        ArrayList<Player> losers = new ArrayList<Player>();
        losers.addAll(this.players);
        losers.removeAll(this.winners);
        for (Player p : this.players) {
            for (String str : this.commandsOnGameEnd) {
                if (this.pl.isPlaceholderIsEnable()) {
                    str = PlaceholderAPI.setPlaceholders((Player)p, (String)str);
                }
                if (str.contains("%winners%")) {
                    str = this.winners.contains(p) ? str.replace("%winners%", p.getName()) : "";
                }
                if (str.contains("%losers%")) {
                    str = losers.contains(p) ? str.replace("%losers%", p.getName()) : "";
                }
                Bukkit.dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), (String)str);
            }
        }
        this.playersAlive = new ArrayList<Player>();
        this.danceFloorActualMaterial = null;
        this.danceFloorColourGroupActualMaterials = new ArrayList<Material>();
        for (Player winner : this.winners) {
            int wins = fc.getInt(winner.getUniqueId() + ".win") + 1;
            fc.set(winner.getUniqueId() + ".win", (Object)wins);
            this.pl.getLeaderboardManager().getWinMap().put(winner.getName(), wins);
            this.pl.getLeaderboardManager().getLooseMap().put(winner.getName(), fc.getInt(winner.getUniqueId() + ".game") - wins);
        }
        FileManager.save(leaderboard, fc);
        this.winners = new ArrayList<Player>();
        this.clearPowerUps();
        final ArrayList<Player> arrayList = new ArrayList<Player>();
        if (this.isAutoRestart()) {
            arrayList.addAll(this.players);
        }
        this.players.clear();
        this.updateSign();
        if (this.isAutoRestart()) {
            if (this.arenaCuboid.getPoint1().getWorld().getUID() != this.exitSpawn.getWorld().getUID()) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.pl, new Runnable(){

                    @Override
                    public void run() {
                        for (Player p : arrayList) {
                            p.performCommand("blockparty:blockparty join " + Arena.this.name);
                        }
                    }
                }, 10L);
            } else {
                for (Player p : arrayList) {
                    p.performCommand("blockparty:blockparty join " + this.name);
                }
            }
            arrayList.clear();
        }
        if (!this.waitDanceFloor.equals("none")) {
            ArrayList<Block> bls = this.danceFloorCuboid.blockList();
            List<Material> customBls = this.pl.getCustomDanceFloorManager().getCustomDanceFloor().get(this.waitDanceFloor);
            if (bls.size() != customBls.size()) {
                this.pl.getDebug().broadcastError("Wait dance floor and the arena dance floor are not the same size");
                this.pl.getDebug().broadcastError("Could not place wait dance floor");
            } else {
                for (int i = 0; i < customBls.size(); ++i) {
                    this.distributedFiller.fillLocation(((Block)bls.get(i)).getLocation(), customBls.get(i), this.workloadRunnable);
                }
            }
        }
    }

    public void clearPowerUps() {
        if (this.powerUpLoc != null) {
            for (Entity en : this.powerUpLoc.getWorld().getNearbyEntities(this.powerUpLoc, this.rangeToCatchPowerup, this.rangeToCatchPowerup, this.rangeToCatchPowerup)) {
                if (en.getType() == EntityType.ARMOR_STAND) {
                    en.remove();
                } else if (this.isPowerUpAsBlock()) {
                    this.powerUpLoc.getBlock().setType(Material.AIR);
                }
                this.powerUpLoc = null;
            }
        }
    }

    public void urgentLeaveGame() {
        this.giveTerracotaTimer.stopTimer();
        this.regenerateBlockTimer.stopTimer();
        this.removeFloorCountDown.stopTimer();
        this.waitLobbyTimer.stopTimer(this);
        this.appreciateTimeFile.stopTimer();
        for (Player p : this.players) {
            p.setGameMode(this.gameModeOnLeave);
            if (this.clearInventory) {
                p.getInventory().clear();
            }
            this.clearPotionEffect(p);
            if (this.isSaveInventory()) {
                this.pl.getInvManager().loadInventory(p);
            }
            if (this.isEnableScoreboard()) {
                this.pl.getScoreBoardUtils().rmvScoreBoard(p);
            }
            p.teleport(this.exitSpawn);
            if (this.radioSongPlayer == null) continue;
            this.radioSongPlayer.removePlayer(p);
            if (this.radioStopSongPlayer == null) continue;
            this.radioStopSongPlayer.removePlayer(p);
        }
        if (this.powerUpLoc != null) {
            for (Entity en : this.powerUpLoc.getWorld().getNearbyEntities(this.powerUpLoc, 0.1, 0.1, 0.1)) {
                if (en.getType() != EntityType.ARMOR_STAND) continue;
                en.remove();
            }
        }
        this.pl.getMusicManager().stopMusic(this);
        this.pl.getMusicManager().stopStopMusic(this);
        this.state = ArenaState.CLEARED;
        this.playersAlive.clear();
        this.players.clear();
        this.winners.clear();
        this.updateSign();
    }

    public void leaveGame(Player p) {
        for (Player pla : this.players) {
            if (p == pla) continue;
            this.pl.getDebug().msg(pla, Language.MSG.LeaveGame.msg(p));
        }
        this.players.remove(p);
        if (this.playerVote.keySet().contains(p)) {
            String lastVotedSong = this.playerVote.get(p);
            this.numberOfVote.put(lastVotedSong, this.numberOfVote.get(lastVotedSong) - 1);
            this.playerVote.remove(p);
            this.songManager.setPlayerSongMap(this.numberOfVote);
            this.songManager.setPlayerVote(this.playerVote);
        }
        if (this.state == ArenaState.INGAME) {
            if (this.playersAlive.contains(p)) {
                this.playersAlive.remove(p);
                this.checkWin();
            }
        } else if (this.state == ArenaState.WATTING && this.players.size() < this.minPlayer) {
            this.waitLobbyTimer.stopTimer(this);
            this.state = ArenaState.CLEARED;
        }
        p.setGameMode(this.gameModeOnLeave);
        if (this.songProvider == SongProvider.NoteBlock && this.radioSongPlayer != null) {
            this.radioSongPlayer.removePlayer(p);
        }
        if (this.songProvider == SongProvider.MCJukebox) {
            this.pl.getMusicManager().stopMcJukeboxMusic(p);
        }
        if (this.songProvider == SongProvider.OpenAudioMC) {
            MediaApi.getInstance().stopFor("BlockParty", new Client[]{ClientApi.getInstance().getClient(p.getUniqueId())});
            MediaApi.getInstance().stopFor("BlockPartyStop", new Client[]{ClientApi.getInstance().getClient(p.getUniqueId())});
        }
        if (this.clearInventory) {
            p.getInventory().clear();
        }
        for (Player players : Bukkit.getOnlinePlayers()) {
            p.showPlayer(players);
        }
        if (this.pl.getPlayerHiderManager().getHidden() != null) {
            this.pl.getPlayerHiderManager().getHidden().remove(p.getUniqueId());
        }
        this.clearPotionEffect(p);
        if (this.isSaveInventory()) {
            this.pl.getInvManager().loadInventory(p);
        }
        if (this.isEnableScoreboard()) {
            this.pl.getScoreBoardUtils().rmvScoreBoard(p);
        }
        p.teleport(this.exitSpawn);
        if (this.winners.contains(p)) {
            this.winners.remove(p);
        }
        this.updateSign();
    }

    public boolean joinParty(Player p) {
        if (this.pl.isPartiesIsEnable()) {
            PartiesAPI api = Parties.getApi();
            PartyPlayer player = api.getPartyPlayer(p.getUniqueId());
            if (!player.isInParty()) {
                JoinArena.joinArena(p, this);
                return true;
            }
            Party party = api.getParty(player.getPartyId());
            if (party != null) {
                if (party.getMembers().size() + this.players.size() <= this.maxPlayer) {
                    for (UUID uuid : party.getMembers()) {
                        JoinArena.joinArena(Bukkit.getPlayer((UUID)uuid), this);
                    }
                    return true;
                }
                this.pl.getDebug().error(p, Language.MSG.youAreToManyToJoinInYourSquad.msg(p));
            }
        }
        return false;
    }

    public boolean checkWin() {
        if (this.playersAlive.size() == 1 && !this.soloGame) {
            End.playerWin(this, this.playersAlive.get(0));
            return true;
        }
        if (this.maxNumberOfRound == this.round || this.playersAlive.size() == 0) {
            End.noMoreRoundWin(this);
            return true;
        }
        return false;
    }

    public void clearPotionEffect(Player p) {
        for (PotionEffect effect : p.getActivePotionEffects()) {
            p.removePotionEffect(effect.getType());
        }
    }

    public void giveStuff(Player p) {
        if (this.giveSlimeBall) {
            ItemStack quit = new ItemStack(XMaterial.SLIME_BALL.parseMaterial());
            ItemMeta quitM = quit.getItemMeta();
            quitM.setDisplayName(ChatColor.RED + "" + ChatColor.BOLD + Language.MSG.LeaveSlimeBall.msg());
            quit.setItemMeta(quitM);
            p.getInventory().setItem(8, quit);
        }
        if (this.giveDye) {
            ItemMeta pinkDyeMeta = this.pinkDye.getItemMeta();
            pinkDyeMeta.setDisplayName(ChatColor.GRAY + Language.MSG.PlayerHiderText.msg() + " \u27af " + ChatColor.RED + Language.MSG.PlayerHiderVisible.msg());
            this.pinkDye.setItemMeta(pinkDyeMeta);
            ItemMeta limeDyeMeta = this.limeDye.getItemMeta();
            limeDyeMeta.setDisplayName(ChatColor.GRAY + Language.MSG.PlayerHiderText.msg() + " \u27af " + ChatColor.GREEN + Language.MSG.PlayerHiderHidden.msg());
            this.limeDye.setItemMeta(limeDyeMeta);
            p.getInventory().setItem(7, this.limeDye);
        }
        if (this.songSetting == SongSetting.CHOOSE) {
            p.getInventory().setItem(0, this.pl.getArenaGui().createIT(XMaterial.PAPER.parseMaterial(), ChatColor.GRAY + Language.MSG.SongSelector.msg(), new String[0]));
        }
    }

    public boolean iscolourGroup() {
        return this.colourGroup;
    }

    public Map<Integer, List<Material>> getColourGroupMap() {
        return this.colourGroupMap;
    }

    public boolean isClearInventory() {
        return this.clearInventory;
    }

    public boolean isGiveSlimeBall() {
        return this.giveSlimeBall;
    }

    public SongProvider getSongProvider() {
        return this.songProvider;
    }

    public void setSongProvider(SongProvider songProvider) {
        this.songProvider = songProvider;
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public Song getChosenSong() {
        return this.chosenSong;
    }

    public void setChosenSong(Song chosenSong) {
        this.chosenSong = chosenSong;
    }

    public void setSongSetting(SongSetting songSetting) {
        this.songSetting = songSetting;
    }

    public SongSetting getSongSetting() {
        return this.songSetting;
    }

    public void setWinners(List<Player> winners) {
        this.winners = winners;
    }

    public boolean isPlayMusic() {
        return this.playMusic;
    }

    public void setPlayMusic(boolean playMusic) {
        this.playMusic = playMusic;
    }

    public boolean isPlayStopMusic() {
        return this.playStopMusic;
    }

    public void setPlayStopMusic(boolean playStopMusic) {
        this.playStopMusic = playStopMusic;
    }

    public List<String> getCommandsOnGameEnd() {
        return this.commandsOnGameEnd;
    }

    public AppreciateTime getAppreciateTimeFile() {
        return this.appreciateTimeFile;
    }

    public GiveTerracotaTimer getGiveTerracotaTimer() {
        return this.giveTerracotaTimer;
    }

    public RegenerateBlockTimer getRegenerateBlockTimer() {
        return this.regenerateBlockTimer;
    }

    public RemoveFloorCountDown getRemoveFloorCountDown() {
        return this.removeFloorCountDown;
    }

    public WaitLobbyTimer getWaitLobbyTimer() {
        return this.waitLobbyTimer;
    }

    public Round getRoundFile() {
        return this.roundFile;
    }

    public BPM getPl() {
        return this.pl;
    }

    public void setPl(BPM pl) {
        this.pl = pl;
    }

    public StartGame getStartGame() {
        return this.startGame;
    }

    public RadioSongPlayer getRadioSongPlayer() {
        return this.radioSongPlayer;
    }

    public void setRadioSongPlayer(RadioSongPlayer radioSongPlayer) {
        this.radioSongPlayer = radioSongPlayer;
    }

    public Song[] getSongs() {
        return this.songs;
    }

    public void setSongs(Song[] songs) {
        this.songs = songs;
    }

    public Song getStopSong() {
        return this.stopSong;
    }

    public void setStopSong(Song stopSong) {
        this.stopSong = stopSong;
    }

    public ArenaState getState() {
        return this.state;
    }

    public void setState(ArenaState state) {
        this.state = state;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPowerUpName() {
        return this.powerUpName;
    }

    public void setPowerUpName(String powerUpName) {
        this.powerUpName = powerUpName;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean getFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public int getMaxPlayer() {
        return this.maxPlayer;
    }

    public void setMaxPlayer(int maxPlayer) {
        this.maxPlayer = maxPlayer;
    }

    public int getMinPlayer() {
        return this.minPlayer;
    }

    public void setMinPlayer(int minPlayer) {
        this.minPlayer = minPlayer;
    }

    public int getLobbyWaitTime() {
        return this.lobbyWaitTime;
    }

    public void setLobbyWaitTime(int lobbyWaitTime) {
        this.lobbyWaitTime = lobbyWaitTime;
    }

    public int getAppreciateTime() {
        return this.appreciateTime;
    }

    public void setAppreciateTime(int appreciateTime) {
        this.appreciateTime = appreciateTime;
    }

    public double getSecondsToRemoveFromRemoveFloorTime() {
        return this.timeToRemoveFromRemoveFloorTime;
    }

    public void setSecondsToRemoveFromRemoveFloorTime(double secondsToRemoveFromRemoveFloorTime) {
        this.timeToRemoveFromRemoveFloorTime = secondsToRemoveFromRemoveFloorTime;
    }

    public double getBaseRemoveFloorTime() {
        return this.baseRemoveFloorTime;
    }

    public void setBaseRemoveFloorTime(double baseRoundTime) {
        this.baseRemoveFloorTime = baseRoundTime;
    }

    public int getRegenerateBlockTime() {
        return this.regenerateBlockTime;
    }

    public void setRegenerateBlockTime(int regenerateBlockTime) {
        this.regenerateBlockTime = regenerateBlockTime;
    }

    public double getRemoveFloorTime() {
        return this.removeFloorTime;
    }

    public void setRemoveFloorTime(double d) {
        this.removeFloorTime = d;
    }

    public int getWaitTimeBeforeGiveColorFirstRound() {
        return this.waitTimeBeforeGiveColorFirstRound;
    }

    public void setWaitTimeBeforeGiveColorFirstRound(int waitTimeBeforeGiveColorFirstRound) {
        this.waitTimeBeforeGiveColorFirstRound = waitTimeBeforeGiveColorFirstRound;
    }

    public int getWaitTimeBeforeGiveColor() {
        return this.waitTimeBeforeGiveColor;
    }

    public void setWaitTimeBeforeGiveColor(int waitTimeBeforeGiveColor) {
        this.waitTimeBeforeGiveColor = waitTimeBeforeGiveColor;
    }

    public boolean isPlayerColision() {
        return this.playerColision;
    }

    public int getDurationPowerUp() {
        return this.durationPowerUp;
    }

    public void setDurationPowerUp(int durationPowerUp) {
        this.durationPowerUp = durationPowerUp;
    }

    public int getLevelOfPowerUp() {
        return this.levelOfPowerUp;
    }

    public void setLevelOfPowerUp(int levelOfPowerUp) {
        this.levelOfPowerUp = levelOfPowerUp;
    }

    public double getRangeToCatchPowerup() {
        return this.rangeToCatchPowerup;
    }

    public void setRangeToCatchPowerup(double rangeToCatchPowerup) {
        this.rangeToCatchPowerup = rangeToCatchPowerup;
    }

    public int getYLevelToDie() {
        return this.YLevelToDie;
    }

    public void setYLevelToDie(int yLevelToDie) {
        this.YLevelToDie = yLevelToDie;
    }

    public int getMaxNumberOfRound() {
        return this.maxNumberOfRound;
    }

    public void setMaxNumberOfRound(int maxNumberOfRound) {
        this.maxNumberOfRound = maxNumberOfRound;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public Material getDanceFloorActualMaterial() {
        return this.danceFloorActualMaterial;
    }

    public void setDanceFloorActualMaterial(Material danceFloorActualMaterial) {
        this.danceFloorActualMaterial = danceFloorActualMaterial;
    }

    public Material getPowerUpHead() {
        return this.powerUpHead;
    }

    public void setPowerUpHead(Material powerUpHead) {
        this.powerUpHead = powerUpHead;
    }

    public List<Material> getDanceFloorFloorMaterials() {
        if (this.colourGroup && this.colourGroupMap.containsKey(this.round)) {
            return this.colourGroupMap.get(this.round);
        }
        return this.danceFloorFloorMaterials;
    }

    public void setDanceFloorFloorMaterials(List<Material> danceFloorFloorMaterials) {
        this.danceFloorFloorMaterials = danceFloorFloorMaterials;
    }

    public List<Integer> getRoundToReduceTime() {
        return this.roundToReduceTime;
    }

    public void setRoundToReduceTime(List<Integer> roundToReduceTime) {
        this.roundToReduceTime = roundToReduceTime;
    }

    public List<Integer> getRoundToSpawnPowerUp() {
        return this.roundToSpawnPowerUp;
    }

    public void setRoundToSpawnPowerUp(List<Integer> roundToSpawnPowerUp) {
        this.roundToSpawnPowerUp = roundToSpawnPowerUp;
    }

    public List<String> getPathToMusic() {
        return this.pathToMusic;
    }

    public void setPathToMusic(List<String> pathToMusic) {
        this.pathToMusic = pathToMusic;
    }

    public String getPathToStopMusic() {
        return this.pathToStopMusic;
    }

    public void setPathToStopMusic(String stopMusic) {
        this.pathToStopMusic = stopMusic;
    }

    public List<Player> getWinners() {
        return this.winners;
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public void addPlayer(Player p) {
        this.players.add(p);
    }

    public void setPlayers(List<Player> players) {
        this.players = players;
    }

    public Map<String, String> getLinkToMusic() {
        return this.linkToMusic;
    }

    public Media getMcJukeboxSong() {
        return this.mcJukeboxSong;
    }

    public Media getMcJukeboxStopSong() {
        return this.mcJukeboxStopSong;
    }

    public String getLinkToStopMusic() {
        return this.linkToStopMusic;
    }

    public void setMcJukeboxSong(Media mcJukeboxSong) {
        this.mcJukeboxSong = mcJukeboxSong;
    }

    public void setMcJukeboxStopSong(Media mcJukeboxStopSong) {
        this.mcJukeboxStopSong = mcJukeboxStopSong;
    }

    public void rmvAlivePlayer(Player p) {
        this.playersAlive.remove(p);
    }

    public List<Player> getPlayersAlive() {
        return this.playersAlive;
    }

    public void addAllPlayersAlive(List<Player> playersAlive) {
        playersAlive.addAll(playersAlive);
    }

    public Location getLobbySpawn() {
        return this.lobbySpawn;
    }

    public void setLobbySpawn(Location lobbySpawn) {
        this.lobbySpawn = lobbySpawn;
    }

    public Location getPowerUpLoc() {
        return this.powerUpLoc;
    }

    public void setPowerUpLoc(Location powerUpLoc) {
        this.powerUpLoc = powerUpLoc;
    }

    public Cuboid getDanceFloorCuboid() {
        return this.danceFloorCuboid;
    }

    public void setDanceFloorCuboid(Cuboid danceFloorCuboid) {
        this.danceFloorCuboid = danceFloorCuboid;
    }

    public List<Sign> getSigns() {
        return this.signs;
    }

    public void setSigns(List<Sign> signs) {
        this.signs = signs;
    }

    public Location getExitSpawn() {
        return this.exitSpawn;
    }

    public void setExitSpawn(Location exitSpawn) {
        this.exitSpawn = exitSpawn;
    }

    public RadioSongPlayer getRadioStopSongPlayer() {
        return this.radioStopSongPlayer;
    }

    public void setRadioStopSongPlayer(RadioSongPlayer radioStopSongPlayer) {
        this.radioStopSongPlayer = radioStopSongPlayer;
    }

    public Cuboid getArenaCuboid() {
        return this.arenaCuboid;
    }

    public void setArenaCuboid(Cuboid arenaCuboid) {
        this.arenaCuboid = arenaCuboid;
    }

    public List<String> getAllowedCommands() {
        return this.allowedCommands;
    }

    public void setAllowedCommands(List<String> allowedCommands) {
        this.allowedCommands = allowedCommands;
    }

    public boolean isChangeTime() {
        return this.changeTime;
    }

    public void setChangeTime(boolean changeTime) {
        this.changeTime = changeTime;
    }

    public GameMode getGmOnDeath() {
        return this.gmOnDeath;
    }

    public void setGmOnDeath(GameMode gmOnDeath) {
        this.gmOnDeath = gmOnDeath;
    }

    public boolean isSaveInventory() {
        return this.saveInventory;
    }

    public void setSaveInventory(boolean saveInventory) {
        this.saveInventory = saveInventory;
    }

    public boolean isGiveDye() {
        return this.giveDye;
    }

    public boolean isResetExp() {
        return this.resetExp;
    }

    public boolean isGiveBlock() {
        return this.giveBlock;
    }

    public ItemStack getLimeDye() {
        return this.limeDye;
    }

    public ItemStack getPinkDye() {
        return this.pinkDye;
    }

    public boolean isAllowJoinDuringGame() {
        return this.allowJoinDuringGame;
    }

    public boolean isAllowPVP() {
        return this.allowPVP;
    }

    public boolean isAutoRestart() {
        return this.autoRestart;
    }

    public boolean isEnableFireworksOnWin() {
        return this.enableFireworksOnWin;
    }

    public boolean isEnableLightnings() {
        return this.enableLightnings;
    }

    public boolean isEnablePowerUps() {
        return this.enablePowerUps;
    }

    public boolean isEnableScoreboard() {
        return this.enableScoreboard;
    }

    public List<String> getCustomDanceFloor() {
        return this.customDanceFloor;
    }

    public void setCustomDanceFloor(List<String> customDanceFloor) {
        this.customDanceFloor = customDanceFloor;
    }

    public Map<Material, List<Location>> getSavedDanceFloorMaterialMap() {
        return this.savedDanceFloorMaterialMap;
    }

    public void setSavedDanceFloorMaterialMap(Map<Material, List<Location>> savedDanceFloorMaterialMap) {
        this.savedDanceFloorMaterialMap = savedDanceFloorMaterialMap;
    }

    public boolean isOnlyCustomFloors() {
        if (this.customDanceFloor.size() == 0 && this.onlyCustomFloors) {
            this.pl.getDebug().broadcastError("There are no custom dance floor even though OnlyCustomFloors setting is set to true");
        }
        return this.onlyCustomFloors;
    }

    public boolean isRandomizeCustomFloor() {
        return this.randomizeCustomFloor;
    }

    public boolean isSoloGame() {
        return this.soloGame;
    }

    public void setSoloGame(boolean soloGame) {
        this.soloGame = soloGame;
    }

    public boolean isNightVision() {
        return this.nightVision;
    }

    public Map<String, String> getOpenAudioMusic() {
        return this.openAudioMusic;
    }

    public void setOpenAudioMusic(Map<String, String> openAudioMusic) {
        this.openAudioMusic = openAudioMusic;
    }

    public String getOpenAudioStopMusic() {
        return this.openAudioStopMusic;
    }

    public void setOpenAudioStopMusic(String openAudioStopMusic) {
        this.openAudioStopMusic = openAudioStopMusic;
    }

    public boolean isNoTitleBar() {
        return this.noTitleBar;
    }

    public void setNoTitleBar(boolean noTitleBar) {
        this.noTitleBar = noTitleBar;
    }

    public boolean isShowColorNameInBarTitle() {
        return this.showColorNameInBarTitle;
    }

    public void setShowColorNameInBarTitle(boolean showColorNameInBarTitle) {
        this.showColorNameInBarTitle = showColorNameInBarTitle;
    }

    public boolean isSmartRandomJoin() {
        return this.smartRandomJoin;
    }

    public void setSmartRandomJoin(boolean smartRandomJoin) {
        this.smartRandomJoin = smartRandomJoin;
    }

    public List<String> getScoreBoard() {
        return this.scoreBoard;
    }

    public void setScoreBoard(List<String> scoreBoard) {
        this.scoreBoard = scoreBoard;
    }

    public List<String> getPowerUps() {
        return this.powerUps;
    }

    public void setPowerUps(List<String> powerUps) {
        this.powerUps = powerUps;
    }

    public DistributedFiller getDistributedFiller() {
        return this.distributedFiller;
    }

    public void setDistributedFiller(DistributedFiller distributedFiller) {
        this.distributedFiller = distributedFiller;
    }

    public WorkloadRunnable getWorkloadRunnable() {
        return this.workloadRunnable;
    }

    public void setWorkloadRunnable(WorkloadRunnable workloadRunnable) {
        this.workloadRunnable = workloadRunnable;
    }

    public double getMaxMillisSecondPerTickToGenerateArenaDanceFloor() {
        return this.maxMillisSecondPerTickToGenerateArenaDanceFloor;
    }

    public void setMaxMillisSecondPerTickToGenerateArenaDanceFloor(double maxMillisSecondPerTickToGenerateArenaDanceFloor) {
        this.maxMillisSecondPerTickToGenerateArenaDanceFloor = maxMillisSecondPerTickToGenerateArenaDanceFloor;
    }

    public List<String> getSignDisplay() {
        return this.signDisplay;
    }

    public void setSignDisplay(List<String> signDisplay) {
        this.signDisplay = signDisplay;
    }

    public Map<String, Integer> getPotionEffects() {
        return this.potionEffects;
    }

    public void setPotionEffects(Map<String, Integer> potionEffects) {
        this.potionEffects = potionEffects;
    }

    public String getWinDanceFloor() {
        return this.winDanceFloor;
    }

    public void setWinDanceFloor(String winDanceFloor) {
        this.winDanceFloor = winDanceFloor;
    }

    public String getWaitDanceFloor() {
        return this.waitDanceFloor;
    }

    public void setWaitDanceFloor(String waitDanceFloor) {
        this.waitDanceFloor = waitDanceFloor;
    }

    public boolean isPowerUpAsBlock() {
        return this.powerUpAsBlock;
    }

    public void setPowerUpAsBlock(boolean powerUpAsBlock) {
        this.powerUpAsBlock = powerUpAsBlock;
    }

    public GameMode getGameModeOnLeave() {
        return this.gameModeOnLeave;
    }

    public void setGameModeOnLeave(GameMode gameModeOnLeave) {
        this.gameModeOnLeave = gameModeOnLeave;
    }

    public boolean isUseSameColourGroup() {
        return this.useSameColourGroup;
    }

    public void setUseSameColourGroup(boolean useSameColourGroup) {
        this.useSameColourGroup = useSameColourGroup;
    }

    public List<Material> getDanceFloorColourGroupActualMaterials() {
        return this.danceFloorColourGroupActualMaterials;
    }

    public void setDanceFloorColourGroupActualMaterials(List<Material> danceFloorColourGroupActualMaterials) {
        this.danceFloorColourGroupActualMaterials = danceFloorColourGroupActualMaterials;
    }

    public int getVolumeNoteBlock() {
        return this.VolumeNoteBlock;
    }

    public boolean isUseParticles() {
        return this.useParticles;
    }

    public int getParticleCount() {
        return this.particleCount;
    }

    public Double getParticleSize() {
        return this.particleSize;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public Color getDefaultParticleColour() {
        return this.defaultParticleColour;
    }

    public ParticleColourSetting getParticleColourSetting() {
        return this.particleColourSetting;
    }

    public String getCustomHeadLink() {
        return this.customHeadLink;
    }

    public boolean isUseCustomHeadLink() {
        return this.useCustomHeadLink;
    }

    public String getSuffix_colour() {
        return this.suffix_colour;
    }

    public void setSuffix_colour(String suffix_colour) {
        this.suffix_colour = suffix_colour;
    }

    public List<Material> getExcludedDanceFloorBlocks() {
        return this.excludedDanceFloorBlocks;
    }

    public void setExcludedDanceFloorBlocks(List<Material> excludedDanceFloorBlocks) {
        this.excludedDanceFloorBlocks = excludedDanceFloorBlocks;
    }
}

