/*
 * Decompiled with CFR 0.152.
 */
package fr.joschma.BlockParty.Arena;

import com.cryptomorin.xseries.XMaterial;
import fr.joschma.BlockParty.Arena.Arena;
import fr.joschma.BlockParty.Arena.State.ArenaState;
import fr.joschma.BlockParty.Arena.State.ParticleColourSetting;
import fr.joschma.BlockParty.Arena.State.SongProvider;
import fr.joschma.BlockParty.Arena.State.SongSetting;
import fr.joschma.BlockParty.BPM;
import fr.joschma.BlockParty.Cuboid.Cuboid;
import fr.joschma.BlockParty.Manager.FileManager;
import fr.joschma.BlockParty.Utils.UtilsLoc;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.configuration.file.YamlConfiguration;

public class InitializeArena {
    BPM pl;

    public InitializeArena(BPM pl) {
        this.pl = pl;
    }

    public void initializeArena() {
        for (String arenaName : this.pl.getAm().getArenaNames()) {
            Object dffm2;
            double removeFloorTime;
            File file = FileManager.loadArenaFile(arenaName);
            YamlConfiguration fc = YamlConfiguration.loadConfiguration((File)file);
            String powerUpName = fc.getString("PowerUp.Name");
            ArenaState state = ArenaState.CLEARED;
            SongSetting songSetting = SongSetting.CHOOSE;
            try {
                songSetting = SongSetting.valueOf(fc.getString("Settings.SongSetting"));
            }
            catch (Exception error) {
                Bukkit.broadcastMessage((String)(this.pl.getUtilsPrefix().getPrefix() + "Song Setting not detected setting to CHOOSE"));
            }
            SongProvider songProvider = SongProvider.valueOf(fc.getString("Settings.SongProvider"));
            boolean finished = fc.getBoolean("Settings.Finished");
            boolean saveInventory = fc.getBoolean("Settings.SaveInventory");
            boolean changeTime = fc.getBoolean("Settings.ChangeTime");
            boolean clearInv = fc.getBoolean("Settings.ClearInventory");
            boolean giveSlimeBall = fc.getBoolean("Settings.GiveSlimeBall");
            boolean resetExp = fc.getBoolean("Settings.HandleExp");
            boolean giveDye = fc.getBoolean("Settings.GiveDye");
            boolean giveBlock = fc.getBoolean("Settings.GiveBlock");
            boolean allowPVP = fc.getBoolean("Settings.AllowPVP");
            boolean autoRestart = fc.getBoolean("Settings.AutoRestart");
            boolean enableLightnings = fc.getBoolean("Settings.EnableLightnings");
            boolean enablePowerUps = fc.getBoolean("Settings.EnablePowerUps");
            boolean enableFireworksOnWin = fc.getBoolean("Settings.EnableFireworksOnWin");
            boolean allowJoinDuringGame = fc.getBoolean("Settings.AllowJoinDuringGame");
            boolean enableScoreboard = fc.getBoolean("Settings.EnableScoreboard");
            boolean onlyCustomFloors = fc.getBoolean("Settings.OnlyCustomFloors");
            boolean randomizeCustomFloor = fc.getBoolean("Settings.RandomizeCustomFloor");
            boolean useColourPalette = fc.getBoolean("Settings.UseColourPalette");
            boolean isNoTitleBar = fc.getBoolean("Settings.IsNoTitleBar");
            boolean showColorNameInBarTitle = fc.getBoolean("Settings.ShowColorNameInBarTitle");
            boolean smartRandomJoin = fc.getBoolean("Settings.SmartRandomJoin");
            double mmspttgadc = fc.getDouble("Settings.MaxMillisSecondPerTickToGenerateArenaDanceFloor");
            GameMode gmOnLeave = GameMode.valueOf((String)fc.getString("Settings.GameModeOnLeave").toUpperCase());
            GameMode gmOnDeath = GameMode.valueOf((String)fc.getString("Game.GameModeOnDeath").toUpperCase());
            boolean collision = fc.getBoolean("Game.Collision");
            int maxPlayer = fc.getInt("Game.MaxPlayer");
            int minPlayer = fc.getInt("Game.MinPlayer");
            int lobbyWaitTime = fc.getInt("Game.LobbyCountDown");
            int appreciateTime = fc.getInt("Game.TimeOnStageAfterWin");
            int regenerateBlockTime = fc.getInt("Game.RegenerateBlockTime");
            int waitTimeBeforeGiveColorFirstRound = fc.getInt("Game.WaitTimeBeforeGiveColorFirstRound");
            int waitTimeBeforeGiveColor = fc.getInt("Game.WaitTimeBeforeGiveColor");
            double timeToRemoveFromRemoveFloorTime = fc.getDouble("Game.TimeReductionPerChosenLevel");
            double baseRemoveFloorTime = removeFloorTime = fc.getDouble("Game.InitialTimeToSearch");
            int durationPowerUp = fc.getInt("PowerUp.Duration");
            int levelOfPowerUp = fc.getInt("PowerUp.LevelOf");
            double rangeToCatchPowerup = fc.getDouble("PowerUp.RangeToCatch");
            int maxNumberOfRound = fc.getInt("Game.MaxNumberOfRound");
            Material powerUpHead = null;
            try {
                powerUpHead = XMaterial.valueOf(fc.getString("PowerUp.Head")).parseMaterial();
            }
            catch (Exception e) {
                Bukkit.broadcastMessage((String)(ChatColor.RED + "No head for power up"));
                Bukkit.broadcastMessage((String)(ChatColor.RED + "Adding head for power up"));
                powerUpHead = XMaterial.CREEPER_HEAD.parseMaterial();
            }
            ArrayList<Material> danceFloorFloorMaterials = new ArrayList<Material>();
            for (Object dffm2 : fc.getStringList("Game.DanceFloorFloorMaterials")) {
                danceFloorFloorMaterials.add(XMaterial.valueOf((String)dffm2).parseMaterial());
            }
            ArrayList<Material> excludedDanceFloorBlocks = new ArrayList<Material>();
            dffm2 = fc.getStringList("Game.ExcludedDanceFloorFloorMaterials").iterator();
            while (dffm2.hasNext()) {
                String dffm3 = (String)dffm2.next();
                excludedDanceFloorBlocks.add(XMaterial.valueOf(dffm3).parseMaterial());
            }
            List roundToSpawnPowerUp = fc.getIntegerList("Game.RoundToSpawnPowerUp");
            List roundToReduceTime = fc.getIntegerList("Game.RoundToReduceTime");
            List pathToMusic = fc.getStringList("Sound.NoteBlock.PathToMusic");
            HashMap<String, String> linkToMusic = new HashMap<String, String>();
            if (fc.getConfigurationSection("Sound.MCJukebox.LinkToMusic") != null) {
                for (String str : fc.getConfigurationSection("Sound.MCJukebox.LinkToMusic").getKeys(false)) {
                    linkToMusic.put(str, fc.getString("Sound.MCJukebox.LinkToMusic." + str));
                }
            }
            String linkToStopMusic = fc.getString("Sound.MCJukebox.LinkToStopMusic");
            String pathToStopMusic = fc.getString("Sound.NoteBlock.PathToStopMusic");
            int VolumeNoteBlock = fc.getInt("Sound.NoteBlock.Volume");
            Location lobbySpawn = UtilsLoc.stringToLoc(fc.getString("Spawn.LobbySpawn"), this.pl);
            Location exitSpawn = UtilsLoc.stringToLoc(fc.getString("Spawn.ExitSpawn"), this.pl);
            int YLevelToDie = 0;
            Cuboid danceFloorCuboid = null;
            Location locDance1 = UtilsLoc.stringToLoc(fc.getString("Cuboid.Dance.Loc1"), this.pl);
            Location locDance2 = UtilsLoc.stringToLoc(fc.getString("Cuboid.Dance.Loc2"), this.pl);
            if (locDance1 != null && locDance2 != null) {
                danceFloorCuboid = new Cuboid(locDance1, locDance2);
                YLevelToDie = (int)(danceFloorCuboid.getLowestY() - 1.0);
            }
            Cuboid arenaFloorCuboid = null;
            Location locArena1 = UtilsLoc.stringToLoc(fc.getString("Cuboid.Arena.Loc1"), this.pl);
            Location locArena2 = UtilsLoc.stringToLoc(fc.getString("Cuboid.Arena.Loc2"), this.pl);
            if (locArena1 != null && locArena2 != null) {
                arenaFloorCuboid = new Cuboid(locArena1, locArena2);
            }
            String winDanceFloor = fc.getString("Cuboid.WinDanceFloor");
            String waitDanceFloor = fc.getString("Cuboid.WaitDanceFloor");
            ArrayList<Sign> signs = new ArrayList<Sign>();
            for (String sign : fc.getStringList("Signs")) {
                BlockState bl;
                if (UtilsLoc.stringToLoc(sign, this.pl) == null || UtilsLoc.stringToLoc(sign, this.pl).getBlock() == null || !((bl = UtilsLoc.stringToLoc(sign, this.pl).getBlock().getState()) instanceof Sign)) continue;
                signs.add((Sign)bl);
            }
            List commandsOnEnd = fc.getStringList("Game.CommandsOnGameEnd");
            List allowedCommands = fc.getStringList("AllowedCommands");
            List customDanceFloorName = fc.getStringList("Cuboid.CustomDanceFloorName");
            List scoreBoard = fc.getStringList("ScoreBoard");
            List powerUps = fc.getStringList("PowerUp.PowerUps");
            HashMap<String, String> openAudioMusic = new HashMap<String, String>();
            if (fc.getConfigurationSection("Sound.OpenAudioMusic") != null) {
                for (String str : fc.getConfigurationSection("Sound.OpenAudioMusic.LinkToMusic").getKeys(false)) {
                    openAudioMusic.put(str, fc.getString("Sound.OpenAudioMusic.LinkToMusic." + str));
                }
            }
            String openAudioStopMusic = fc.getString("Sound.OpenAudioMusic.LinkToStopMusic");
            List signDisplay = fc.getStringList("SignDisplay");
            HashMap<String, Integer> potionEffects = new HashMap<String, Integer>();
            if (fc.getConfigurationSection("Game.Potions") != null) {
                for (String str : fc.getConfigurationSection("Game.Potions").getKeys(false)) {
                    potionEffects.put(str, fc.getInt("Game.Potions." + str));
                }
            }
            boolean powerUpAsBlock = fc.getBoolean("PowerUp.PowerUpAsBlock");
            boolean useSameColourGroup = fc.getBoolean("Game.UseSameColourGroup");
            boolean useParticles = fc.getBoolean("Game.Particles.Use");
            int particlesCount = fc.getInt("Game.Particles.Count");
            Double particlesSize = fc.getDouble("Game.Particles.Size");
            Particle particle = Particle.valueOf((String)fc.getString("Game.Particles.Type").toUpperCase());
            Color defaultColour = fc.getColor("Game.Particles.DefaultColour");
            ParticleColourSetting particleColourSetting = ParticleColourSetting.valueOf(fc.getString("Game.Particles.ColourSetting").toUpperCase());
            String customHeadLink = fc.getString("PowerUp.CustomHead.Link");
            boolean useCustomHead = fc.getBoolean("PowerUp.CustomHead.Use");
            File colourLanguageFile = FileManager.load("ColourLanguage");
            YamlConfiguration fcColourLanguage = YamlConfiguration.loadConfiguration((File)colourLanguageFile);
            String colour_suffix = fcColourLanguage.getString("Suffix");
            Arena a = new Arena(this.pl, arenaName, powerUpName, file, state, songSetting, finished, maxPlayer, minPlayer, lobbyWaitTime, appreciateTime, regenerateBlockTime, waitTimeBeforeGiveColorFirstRound, waitTimeBeforeGiveColor, timeToRemoveFromRemoveFloorTime, removeFloorTime, baseRemoveFloorTime, 0, durationPowerUp, levelOfPowerUp, rangeToCatchPowerup, YLevelToDie, maxNumberOfRound, powerUpHead, danceFloorFloorMaterials, roundToSpawnPowerUp, roundToReduceTime, pathToMusic, linkToMusic, linkToStopMusic, signs, pathToStopMusic, lobbySpawn, exitSpawn, danceFloorCuboid, arenaFloorCuboid, allowedCommands, commandsOnEnd, collision, changeTime, gmOnDeath, saveInventory, songProvider, giveSlimeBall, clearInv, giveDye, resetExp, giveBlock, allowPVP, autoRestart, enableLightnings, enablePowerUps, enableFireworksOnWin, allowJoinDuringGame, enableScoreboard, customDanceFloorName, randomizeCustomFloor, onlyCustomFloors, useColourPalette, false, openAudioMusic, openAudioStopMusic, isNoTitleBar, showColorNameInBarTitle, smartRandomJoin, scoreBoard, powerUps, mmspttgadc, signDisplay, potionEffects, winDanceFloor, waitDanceFloor, powerUpAsBlock, gmOnLeave, useSameColourGroup, useParticles, particlesCount, particlesSize, particle, defaultColour, particleColourSetting, customHeadLink, useCustomHead, colour_suffix, excludedDanceFloorBlocks, VolumeNoteBlock);
            this.pl.getAm().addArena(a);
            if (fc.getConfigurationSection("Game.ColourPalette.Round") == null) continue;
            for (String round : fc.getConfigurationSection("Game.ColourPalette.Round").getKeys(false)) {
                ArrayList<Material> mas = new ArrayList<Material>();
                for (String ma : fc.getStringList("Game.ColourPalette.Round." + round)) {
                    mas.add(Material.valueOf((String)ma));
                }
                a.getColourGroupMap().put(Integer.valueOf(round), mas);
            }
        }
    }

    public void saveArena(Arena a) {
        File file = a.getFile();
        YamlConfiguration fc = YamlConfiguration.loadConfiguration((File)file);
        fc.set("Settings.Finished", (Object)a.getFinished());
        fc.set("Settings.SongSetting", (Object)a.getSongSetting().toString());
        fc.set("Settings.ChangeTime", (Object)a.isChangeTime());
        fc.set("Settings.SaveInventory", (Object)a.isSaveInventory());
        fc.set("Settings.ClearInventory", (Object)a.isClearInventory());
        fc.set("Settings.GiveSlimeBall", (Object)a.isGiveSlimeBall());
        fc.set("Settings.HandleExp", (Object)a.isResetExp());
        fc.set("Settings.GiveDye", (Object)a.isGiveDye());
        fc.set("Settings.SongProvider", (Object)a.getSongProvider().toString());
        fc.set("Settings.GiveBlock", (Object)a.isGiveBlock());
        fc.set("Settings.AllowPVP", (Object)a.isAllowPVP());
        fc.set("Settings.AutoRestart", (Object)a.isAutoRestart());
        fc.set("Settings.EnableLightnings", (Object)a.isEnableLightnings());
        fc.set("Settings.EnablePowerUps", (Object)a.isEnablePowerUps());
        fc.set("Settings.EnableFireworksOnWin", (Object)a.isEnableFireworksOnWin());
        fc.set("Settings.AllowJoinDuringGame", (Object)a.isAllowJoinDuringGame());
        fc.set("Settings.EnableScoreboard", (Object)a.isEnableScoreboard());
        fc.set("Settings.OnlyCustomFloors", (Object)a.isOnlyCustomFloors());
        fc.set("Settings.RandomizeCustomFloor", (Object)a.isRandomizeCustomFloor());
        fc.set("Settings.UseColourPalette", (Object)a.iscolourGroup());
        fc.set("Settings.IsNoTitleBar", (Object)a.isNoTitleBar());
        fc.set("Settings.ShowColorNameInBarTitle", (Object)a.isShowColorNameInBarTitle());
        fc.set("Settings.SmartRandomJoin", (Object)a.isSmartRandomJoin());
        fc.set("Settings.MaxMillisSecondPerTickToGenerateArenaDanceFloor", (Object)a.getMaxMillisSecondPerTickToGenerateArenaDanceFloor());
        fc.set("Settings.GameModeOnLeave", (Object)a.getGameModeOnLeave().toString());
        fc.set("Game.Collision", (Object)a.isPlayerColision());
        fc.set("Game.MaxPlayer", (Object)a.getMaxPlayer());
        fc.set("Game.MinPlayer", (Object)a.getMinPlayer());
        fc.set("Game.LobbyCountDown", (Object)a.getLobbyWaitTime());
        fc.set("Game.TimeOnStageAfterWin", (Object)a.getAppreciateTime());
        fc.set("Game.RegenerateBlockTime", (Object)a.getRegenerateBlockTime());
        fc.set("Game.WaitTimeBeforeGiveColorFirstRound", (Object)a.getWaitTimeBeforeGiveColorFirstRound());
        fc.set("Game.WaitTimeBeforeGiveColor", (Object)a.getWaitTimeBeforeGiveColor());
        fc.set("Game.TimeReductionPerChosenLevel", (Object)a.getSecondsToRemoveFromRemoveFloorTime());
        fc.set("Game.InitialTimeToSearch", (Object)a.getBaseRemoveFloorTime());
        fc.set("Game.RoundToSpawnPowerUp", a.getRoundToSpawnPowerUp());
        fc.set("Game.RoundToReduceTime", a.getRoundToReduceTime());
        fc.set("Game.CommandsOnGameEnd", a.getCommandsOnGameEnd());
        fc.set("Game.GameModeOnDeath", (Object)a.getGmOnDeath().toString());
        fc.set("Game.MaxNumberOfRound", (Object)a.getMaxNumberOfRound());
        for (String string : a.getPotionEffects().keySet()) {
            fc.set("Game.Potions." + string, (Object)a.getPotionEffects().get(string));
        }
        ArrayList<String> dfm = new ArrayList<String>();
        for (Material material : a.getDanceFloorFloorMaterials()) {
            dfm.add(String.valueOf(material));
        }
        fc.set("Game.DanceFloorFloorMaterials", dfm);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Material mat : a.getExcludedDanceFloorBlocks()) {
            arrayList.add(String.valueOf(mat));
        }
        fc.set("Game.ExcludedDanceFloorFloorMaterials", arrayList);
        fc.set("Game.Particles.Use", (Object)a.isUseParticles());
        fc.set("Game.Particles.Count", (Object)a.getParticleCount());
        fc.set("Game.Particles.Size", (Object)a.getParticleSize());
        fc.set("Game.Particles.Type", (Object)a.getParticle().toString());
        fc.set("Game.Particles.DefaultColour", (Object)a.getDefaultParticleColour());
        fc.set("Game.Particles.ColourSetting", (Object)a.getParticleColourSetting().toString());
        fc.set("Game.UseSameColourGroup", (Object)a.isUseSameColourGroup());
        fc.set("PowerUp.Duration", (Object)a.getDurationPowerUp());
        fc.set("PowerUp.RangeToCatch", (Object)a.getRangeToCatchPowerup());
        fc.set("PowerUp.LevelOf", (Object)a.getLevelOfPowerUp());
        fc.set("PowerUp.Name", (Object)a.getPowerUpName());
        fc.set("PowerUp.Head", (Object)String.valueOf(a.getPowerUpHead()));
        fc.set("PowerUp.PowerUps", a.getPowerUps());
        fc.set("PowerUp.PowerUpAsBlock", (Object)a.isPowerUpAsBlock());
        fc.set("PowerUp.CustomHead.Link", (Object)a.getCustomHeadLink());
        fc.set("PowerUp.CustomHead.Use", (Object)a.isUseCustomHeadLink());
        fc.set("Sound.NoteBlock.Volume", (Object)a.getVolumeNoteBlock());
        fc.set("Sound.NoteBlock.PathToMusic", a.getPathToMusic());
        fc.set("Sound.NoteBlock.PathToStopMusic", (Object)a.getPathToStopMusic());
        for (String name : a.getLinkToMusic().keySet()) {
            fc.set("Sound.MCJukebox.LinkToMusic." + name, (Object)a.getLinkToMusic().get(name));
        }
        for (String name : a.getOpenAudioMusic().keySet()) {
            fc.set("Sound.OpenAudioMusic.LinkToMusic." + name, (Object)a.getOpenAudioMusic().get(name));
        }
        fc.set("Sound.OpenAudioMusic.LinkToStopMusic", (Object)a.getOpenAudioStopMusic());
        fc.set("Sound.MCJukebox.LinkToStopMusic", (Object)a.getLinkToStopMusic());
        if (a.getLobbySpawn() != null) {
            fc.set("Spawn.LobbySpawn", (Object)UtilsLoc.locToString(a.getLobbySpawn()));
        }
        if (a.getExitSpawn() != null) {
            fc.set("Spawn.ExitSpawn", (Object)UtilsLoc.locToString(a.getExitSpawn()));
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (a.getSigns() != null) {
            for (Sign sign : a.getSigns()) {
                arrayList2.add(UtilsLoc.locToString(sign.getLocation()));
            }
        }
        fc.set("Signs", arrayList2);
        fc.set("Cuboid.WinDanceFloor", (Object)a.getWinDanceFloor());
        fc.set("Cuboid.WaitDanceFloor", (Object)a.getWaitDanceFloor());
        fc.set("Cuboid.CustomDanceFloorName", a.getCustomDanceFloor());
        if (a.getDanceFloorCuboid() != null) {
            fc.set("Cuboid.Dance.Loc1", (Object)UtilsLoc.locToString(a.getDanceFloorCuboid().getPoint1()));
            fc.set("Cuboid.Dance.Loc2", (Object)UtilsLoc.locToString(a.getDanceFloorCuboid().getPoint2()));
        }
        if (a.getArenaCuboid() != null) {
            fc.set("Cuboid.Arena.Loc1", (Object)UtilsLoc.locToString(a.getArenaCuboid().getPoint1()));
            fc.set("Cuboid.Arena.Loc2", (Object)UtilsLoc.locToString(a.getArenaCuboid().getPoint2()));
        }
        fc.set("AllowedCommands", a.getAllowedCommands());
        fc.set("ScoreBoard", a.getScoreBoard());
        fc.set("SignDisplay", a.getSignDisplay());
        if (a.getPl().getVersion() > 17) {
            this.setComments(fc);
        }
        FileManager.save(file, fc);
    }

    public void setComments(YamlConfiguration fc) {
        fc.setComments("Game.ExcludedDanceFloorFloorMaterials", Arrays.asList("All the blocks that can be on the ground but not be selected as a colour"));
        fc.setComments("Spawn", Arrays.asList("All the coordinates for the spawns"));
        fc.setComments("Game.Particles.Use", Arrays.asList("Should particles spawn when a block disappear"));
        fc.setComments("Game.Particles.Count", Arrays.asList("The number of particles spawned"));
        fc.setComments("Game.Particles.Size", Arrays.asList("The size of each particle spawned"));
        fc.setComments("Game.Potions", Arrays.asList("All the potion effect a player has in game (POTION_NAME:POTION STRENGTH)", "Values can be found at https://javadoc.io/doc/com.github.cryptomorin/XSeries/latest/com/cryptomorin/xseries/XPotion.html"));
        fc.setComments("SignDisplay", Arrays.asList("What will be seen on signs for this arena"));
        fc.setComments("Settings.Finished", Arrays.asList("Is the party ready to be played"));
        fc.setComments("Settings.SongSetting", Arrays.asList("RANDOM --> players will not be able to chose the song.CHOOSE --> players can chose what song will be played"));
        fc.setComments("Settings.ChangeTime", Arrays.asList("Only in the waiting room the time of the day  is going to change depending on the wait lobby timer"));
        fc.setComments("Settings.SaveInventory", Arrays.asList("Should the plugin save the inventory of the player and give it back at the end of the game"));
        fc.setComments("Settings.ClearInventory", Arrays.asList("If false players can keep their stuff in game"));
        fc.setComments("Settings.GiveSlimeBall", Arrays.asList("Should the plugin give the item to leave the game"));
        fc.setComments("Settings.HandleExp", Arrays.asList("Should the plugin save the exp of the player and give it back at the end of the game"));
        fc.setComments("Settings.GiveDye", Arrays.asList("Should the plugin give the item to hide other player"));
        fc.setComments("Settings.SongProvider", Arrays.asList("The plugin that will play the songs (MCJukebox, NoteBlock, OpenAudioMC"));
        fc.setComments("Settings.GiveBlock", Arrays.asList("Should the plugin give the block that need to be stand on"));
        fc.setComments("Settings.AllowPVP", Arrays.asList("Can player attack other player"));
        fc.setComments("Settings.AutoRestart", Arrays.asList("Should the game start again after the end of it"));
        fc.setComments("Settings.EnableLightnings", Arrays.asList("Should the plugin shoot lightnings on the player death location"));
        fc.setComments("Settings.EnablePowerUps", Arrays.asList("Should all power ups be active"));
        fc.setComments("Settings.EnableFireworksOnWin", Arrays.asList("Should the plugin shoot fire works at the end of the game"));
        fc.setComments("Settings.AllowJoinDuringGame", Arrays.asList("Can people join the game as spectator"));
        fc.setComments("Settings.EnableScoreboard", Arrays.asList("Should the player have the scoreboard"));
        fc.setComments("Settings.OnlyCustomFloors", Arrays.asList("Play only with custom floors"));
        fc.setComments("Settings.RandomizeCustomFloor", Arrays.asList("Should the plugin swap the same colours for another one with custom floors"));
        fc.setComments("Settings.UseColourPalette", Arrays.asList("Should the plugin use only the colours in the colour palette"));
        fc.setComments("Settings.IsNoTitleBar", Arrays.asList("Disable the bar above the health"));
        fc.setComments("Settings.ShowColorNameInBarTitle", Arrays.asList("Should the name of the colour be displayed on the bar above the health"));
        fc.setComments("Settings.SmartRandomJoin", Arrays.asList("This will help to fill lobbies quicker"));
        fc.setComments("Settings.MaxMillisSecondPerTickToGenerateArenaDanceFloor", Arrays.asList("This should be dealt with caution : the time (in milli seconds) in which the plugin will place blocks ever tick", "The greater the surface of your dance floor the bigger this number has to be", "The max is 50"));
        fc.setComments("Game.Collision", Arrays.asList("Should player collide"));
        fc.setComments("Game.MaxPlayer", Arrays.asList("What is the maximum of player in this arena"));
        fc.setComments("Game.MinPlayer", Arrays.asList("What is the number of player necessary to start the lobby count down"));
        fc.setComments("Game.LobbyCountDown", Arrays.asList("The length of the lobby count down until the game starts"));
        fc.setComments("Game.TimeOnStageAfterWin", Arrays.asList("The time that winners stay on the dance floor"));
        fc.setComments("Game.RegenerateBlockTime", Arrays.asList("The time that player have to stop dancing"));
        fc.setComments("Game.WaitTimeBeforeGiveColorFirstRound", Arrays.asList("The time (only for the first round) that people have to wait toget the block they need to go on"));
        fc.setComments("Game.WaitTimeBeforeGiveColor", Arrays.asList("For all the other round the time that people get to rest from the lasttime they stopped dancing"));
        fc.setComments("Game.TimeReductionPerChosenLevel", Arrays.asList("The time that will be subtracted to each round (so that the time playershave to go to the block is smaller)"));
        fc.setComments("Game.InitialTimeToSearch", Arrays.asList("The time for the first round that people have to go on the block they have to"));
        fc.setComments("Game.RoundToSpawnPowerUp", Arrays.asList("The rounds in which power ups will spawn"));
        fc.setComments("Game.RoundToReduceTime", Arrays.asList("The round where the TimeReductionPerChosenLevel is going to be applied"));
        fc.setComments("Game.CommandsOnGameEnd", Arrays.asList("All the command that will be executed at the end of each game"));
        fc.setComments("Game.GameModeOnDeath", Arrays.asList("The game mode in which all spectator will be put"));
        fc.setComments("Game.MaxNumberOfRound", Arrays.asList("The maximum number of round before all the remaining player will win"));
        fc.setComments("Game.DanceFloorFloorMaterials", Arrays.asList("The list of all the blocks that could be in the dance floor"));
        fc.setComments("Game.SameColourGroup.Use", Arrays.asList("If true, all block of same colour will stay"));
        fc.setComments("Game.SameColourGroup.ExcludeDarkInHand", Arrays.asList("Shouldn't the block containing the name dark will be given to the player", "But they will stay on the dance floor"));
        fc.setComments("Game.SameColourGroup.ExcludeLightInHand", Arrays.asList("If true, the block containing the name light will not be given to the player", "But they will stay on the dance floor"));
        fc.setComments("Game.Particles.DefaultColour", Arrays.asList("The colour of the particle if the plugin can't find the colour of the block"));
        fc.setComments("Game.Particles.ColourSetting", Arrays.asList("It can be [Random, RemovedBlockColour, InHandBlockColour]"));
        fc.setComments("PowerUp.Duration", Arrays.asList("The time the power up will last"));
        fc.setComments("PowerUp.RangeToCatch", Arrays.asList("The distance needed to catch the power up"));
        fc.setComments("PowerUp.LevelOf", Arrays.asList("The level of the potion effect that will be given"));
        fc.setComments("PowerUp.Name", Arrays.asList("The name that people will see above power ups"));
        fc.setComments("PowerUp.Head", Arrays.asList("The block that people will see as the power up"));
        fc.setComments("PowerUp.PowerUps", Arrays.asList("The list of all the power up (you can remove some)"));
        fc.setComments("PowerUp.PowerUpAsBlock", Arrays.asList("Should the power up be a block or just a floating entity"));
        fc.setComments("PowerUp.CustomHead.Link", Arrays.asList("You can find custom head here: https://minecraft-heads.com", "You need to get the last link (Minecraft-URL)"));
        fc.setComments("PowerUp.CustomHead.Use", Arrays.asList("Should the plugin use custom heads"));
        fc.setComments("Sound.NoteBlock.Volume", Arrays.asList("The volume at which the music will play"));
        fc.setComments("Sound.NoteBlock.PathToMusic", Arrays.asList("The file path to all the music that will be played in game"));
        fc.setComments("Sound.NoteBlock.PathToStopMusic", Arrays.asList("The file path to the music that will be played when the dance music stops"));
        fc.setComments("Sound.MCJukebox.LinkToMusic", Arrays.asList("The link to all the music that will be played in game"));
        fc.setComments("Sound.MCJukebox.LinkToStopMusic", Arrays.asList("The link to the music that will be played when the dance music stops"));
        fc.setComments("Sound.OpenAudioMusic.LinkToMusic", Arrays.asList("The link to all the music that will be played in game"));
        fc.setComments("Sound.OpenAudioMusic.LinkToStopMusic", Arrays.asList("The link to the music that will be played when the dance music stops"));
        fc.setComments("Signs", Arrays.asList("All the signs that lead to this party"));
        fc.setComments("Cuboid.CustomDanceFloorName", Arrays.asList("All the custom dance floors that can be played in this party"));
        fc.setComments("Cuboid.WinDanceFloor", Arrays.asList("The custom dance floor that will will be loaded when player win"));
        fc.setComments("Cuboid.WaitDanceFloor", Arrays.asList("The custom dance floor that will will be loaded when player wait"));
        fc.setComments("AllowedCommands", Arrays.asList("All the allowed command in game for all player"));
        fc.setComments("ScoreBoard", Arrays.asList("The scoreboard that every one can see on their right"));
    }
}

