/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.ReflectionUtils;
import com.cryptomorin.xseries.XMaterial;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public final class SkullUtils {
    protected static final MethodHandle CRAFT_META_SKULL_PROFILE_GETTER;
    protected static final MethodHandle CRAFT_META_SKULL_PROFILE_SETTER;
    protected static final MethodHandle CRAFT_META_SKULL_BLOCK_SETTER;
    protected static final MethodHandle PROPERTY_GETVALUE;
    private static final String VALUE_PROPERTY = "{\"textures\":{\"SKIN\":{\"url\":\"";
    public static final boolean SUPPORTS_UUID;
    private static final String INVALID_SKULL_VALUE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzEwNTkxZTY5MDllNmEyODFiMzcxODM2ZTQ2MmQ2N2EyYzc4ZmEwOTUyZTkxMGYzMmI0MWEyNmM0OGMxNzU3YyJ9fX0=";
    private static final Pattern MOJANG_SHA256_APPROX;
    private static final AtomicLong MOJANG_SHA_FAKE_ID_ENUMERATOR;
    private static final Map<String, GameProfile> MOJANG_SHA_FAKE_PROFILES;
    private static final Map<String, GameProfile> NULL_PLAYERS;
    private static final boolean NULLABILITY_RECORD_UPDATE;
    private static final UUID IDENTITY_UUID;
    private static final GameProfile NULL_PROFILE;
    private static final UUID GAME_PROFILE_EMPTY_UUID;
    private static final String GAME_PROFILE_EMPTY_NAME;
    private static final String TEXTURES = "https://textures.minecraft.net/texture/";

    @Nonnull
    public static ItemStack getSkull(@Nonnull UUID id) {
        ItemStack head = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)id);
        if (SUPPORTS_UUID) {
            meta.setOwningPlayer(player);
        } else {
            meta.setOwner(player.getName());
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta head, @Nonnull OfflinePlayer identifier) {
        SkullMeta meta = (SkullMeta)head;
        if (SUPPORTS_UUID) {
            meta.setOwningPlayer(identifier);
        } else {
            meta.setOwner(identifier.getName());
        }
        return meta;
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta head, @Nonnull UUID identifier) {
        return SkullUtils.applySkin(head, Bukkit.getOfflinePlayer((UUID)identifier));
    }

    private static SkullMeta applySkinFromName(SkullMeta head, String name) {
        GameProfile nullPlayer = NULL_PLAYERS.get(name);
        if (nullPlayer == NULL_PROFILE) {
            return head;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)name);
        UUID nullUUID = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8));
        if (player.getUniqueId().equals(nullUUID)) {
            NULL_PLAYERS.put(name, NULL_PROFILE);
            return head;
        }
        return SkullUtils.applySkin((ItemMeta)head, player);
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta head, @Nonnull String identifier) {
        SkullMeta meta = (SkullMeta)head;
        StringSkullCache result = SkullUtils.detectSkullValueType(identifier);
        switch (result.valueType) {
            case UUID: {
                return SkullUtils.applySkin((ItemMeta)meta, Bukkit.getOfflinePlayer((UUID)((UUID)result.object)));
            }
            case NAME: {
                return SkullUtils.applySkinFromName(meta, identifier);
            }
            case BASE64: {
                return SkullUtils.setSkullBase64(meta, identifier, SkullUtils.extractMojangSHAFromBase64((String)result.object));
            }
            case TEXTURE_URL: {
                return SkullUtils.setSkullBase64(meta, SkullUtils.encodeTexturesURL(identifier), SkullUtils.extractMojangSHAFromBase64(identifier));
            }
            case TEXTURE_HASH: {
                return SkullUtils.setSkullBase64(meta, SkullUtils.encodeTexturesURL(TEXTURES + identifier), identifier);
            }
            case UNKNOWN: {
                return SkullUtils.setSkullBase64(meta, INVALID_SKULL_VALUE, INVALID_SKULL_VALUE);
            }
        }
        throw new AssertionError((Object)"Unknown skull value");
    }

    @Nonnull
    public static SkullMeta setSkullBase64(@Nonnull SkullMeta head, @Nonnull String value, String MojangSHA) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Skull value cannot be null or empty");
        }
        GameProfile profile = SkullUtils.profileFromBase64(value, MojangSHA);
        SkullUtils.setProfile(head, profile);
        return head;
    }

    public static void setProfile(SkullMeta head, GameProfile profile) {
        try {
            CRAFT_META_SKULL_PROFILE_SETTER.invoke(head, profile);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Nonnull
    public static GameProfile profileFromBase64(String base64, String MojangSHA) {
        GameProfile gp = MOJANG_SHA_FAKE_PROFILES.get(MojangSHA);
        if (gp != null) {
            return gp;
        }
        gp = new GameProfile(NULLABILITY_RECORD_UPDATE ? GAME_PROFILE_EMPTY_UUID : new UUID(MOJANG_SHA_FAKE_ID_ENUMERATOR.getAndIncrement(), 0L), GAME_PROFILE_EMPTY_NAME);
        gp.getProperties().put((Object)"textures", (Object)new Property("textures", base64));
        MOJANG_SHA_FAKE_PROFILES.put(MojangSHA, gp);
        return gp;
    }

    @Nonnull
    public static GameProfile profileFromPlayer(OfflinePlayer player) {
        return new GameProfile(player.getUniqueId(), player.getName());
    }

    @Nonnull
    public static GameProfile detectProfileFromString(String identifier) {
        StringSkullCache result = SkullUtils.detectSkullValueType(identifier);
        switch (result.valueType) {
            case UUID: {
                return new GameProfile((UUID)result.object, GAME_PROFILE_EMPTY_NAME);
            }
            case NAME: {
                return new GameProfile(GAME_PROFILE_EMPTY_UUID, identifier);
            }
            case BASE64: {
                return SkullUtils.profileFromBase64(identifier, SkullUtils.extractMojangSHAFromBase64((String)result.object));
            }
            case TEXTURE_URL: {
                return SkullUtils.profileFromBase64(SkullUtils.encodeTexturesURL(identifier), SkullUtils.extractMojangSHAFromBase64(identifier));
            }
            case TEXTURE_HASH: {
                return SkullUtils.profileFromBase64(SkullUtils.encodeTexturesURL(TEXTURES + identifier), identifier);
            }
            case UNKNOWN: {
                return SkullUtils.profileFromBase64(INVALID_SKULL_VALUE, INVALID_SKULL_VALUE);
            }
        }
        throw new AssertionError((Object)"Unknown skull value");
    }

    @Nonnull
    public static StringSkullCache detectSkullValueType(@Nonnull String identifier) {
        try {
            UUID id = UUID.fromString(identifier);
            return new StringSkullCache(ValueType.UUID, id);
        }
        catch (IllegalArgumentException id) {
            String decoded;
            if (SkullUtils.isUsername(identifier)) {
                return new StringSkullCache(ValueType.NAME);
            }
            if (identifier.contains("textures.minecraft.net")) {
                return new StringSkullCache(ValueType.TEXTURE_URL);
            }
            if (identifier.length() > 100 && (decoded = SkullUtils.decodeBase64(identifier)) != null) {
                return new StringSkullCache(ValueType.BASE64, decoded);
            }
            if (MOJANG_SHA256_APPROX.matcher(identifier).matches()) {
                return new StringSkullCache(ValueType.TEXTURE_HASH);
            }
            return new StringSkullCache(ValueType.UNKNOWN);
        }
    }

    public static void setSkin(@Nonnull Block block, @Nonnull String value) {
        Objects.requireNonNull(block, "Can't set skin of null block");
        BlockState state = block.getState();
        SkullUtils.setSkin(state, value);
        state.update(true);
    }

    public static void setSkin(@Nonnull BlockState state, @Nonnull String value) {
        SkullUtils.setSkin(state, SkullUtils.detectProfileFromString(value));
    }

    public static void setSkin(@Nonnull BlockState state, @Nonnull GameProfile profile) {
        Objects.requireNonNull(state, "Can't set skin of null block state");
        Objects.requireNonNull(profile, "Can't set skin of block with null GameProfile");
        if (!(state instanceof Skull)) {
            throw new IllegalArgumentException("Cannot set skin of a block that is not a skull: " + state);
        }
        Skull skull = (Skull)state;
        try {
            CRAFT_META_SKULL_BLOCK_SETTER.invoke(skull, profile);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while setting block skin with value: " + state + " with profiel " + profile, e);
        }
    }

    public static String encodeTexturesURL(String url) {
        return SkullUtils.encodeBase64(VALUE_PROPERTY + url + "\"}}}");
    }

    @Nonnull
    private static String encodeBase64(@Nonnull String str) {
        return Base64.getEncoder().encodeToString(str.getBytes(StandardCharsets.UTF_8));
    }

    private static String decodeBase64(@Nonnull String base64) {
        try {
            byte[] bytes = Base64.getDecoder().decode(base64);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    @Nullable
    public static String getSkinValue(@Nonnull ItemMeta skull) {
        Objects.requireNonNull(skull, "Skull ItemStack cannot be null");
        SkullMeta meta = (SkullMeta)skull;
        GameProfile profile = null;
        try {
            profile = CRAFT_META_SKULL_PROFILE_GETTER.invoke(meta);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (profile != null && !profile.getProperties().get((Object)"textures").isEmpty()) {
            for (Property property : profile.getProperties().get((Object)"textures")) {
                String value = SkullUtils.getPropertyValue(property);
                if (value.isEmpty()) continue;
                return value;
            }
        }
        return null;
    }

    private static String getPropertyValue(Property property) {
        if (NULLABILITY_RECORD_UPDATE) {
            return property.value();
        }
        try {
            return PROPERTY_GETVALUE.invoke(property);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static String extractMojangSHAFromBase64(String decodedBase64) {
        int startIndex = decodedBase64.lastIndexOf(47);
        int endIndex = decodedBase64.lastIndexOf(34);
        if (startIndex == -1 || endIndex == -1 || startIndex >= endIndex) {
            throw new IllegalArgumentException("Invalid Base64 skull value: " + decodedBase64);
        }
        try {
            return decodedBase64.substring(startIndex + 1, endIndex);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Invalid Base64 skull value: " + decodedBase64, ex);
        }
    }

    private static boolean isUsername(@Nonnull String name) {
        int len = name.length();
        if (len > 16) {
            return false;
        }
        UnmodifiableIterator unmodifiableIterator = Lists.charactersOf((String)name).iterator();
        while (unmodifiableIterator.hasNext()) {
            char ch = ((Character)unmodifiableIterator.next()).charValue();
            if (ch == '_' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        SUPPORTS_UUID = ReflectionUtils.supports(12);
        MOJANG_SHA256_APPROX = Pattern.compile("[0-9a-z]{55,70}");
        MOJANG_SHA_FAKE_ID_ENUMERATOR = new AtomicLong(1L);
        MOJANG_SHA_FAKE_PROFILES = new HashMap<String, GameProfile>();
        NULL_PLAYERS = new HashMap<String, GameProfile>();
        NULLABILITY_RECORD_UPDATE = ReflectionUtils.supports(20, 2);
        IDENTITY_UUID = new UUID(0L, 0L);
        NULL_PROFILE = new GameProfile(IDENTITY_UUID, "");
        GAME_PROFILE_EMPTY_UUID = NULLABILITY_RECORD_UPDATE ? IDENTITY_UUID : null;
        GAME_PROFILE_EMPTY_NAME = NULLABILITY_RECORD_UPDATE ? "" : null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle profileSetter = null;
        MethodHandle profileGetter = null;
        MethodHandle blockSetter = null;
        MethodHandle propGetval = null;
        try {
            Class<?> CraftMetaSkull = ReflectionUtils.getCraftClass("inventory.CraftMetaSkull");
            Field profile = CraftMetaSkull.getDeclaredField("profile");
            profile.setAccessible(true);
            profileGetter = lookup.unreflectGetter(profile);
            try {
                Method setProfile = CraftMetaSkull.getDeclaredMethod("setProfile", GameProfile.class);
                setProfile.setAccessible(true);
                profileSetter = lookup.unreflect(setProfile);
            }
            catch (NoSuchMethodException e) {
                profileSetter = lookup.unreflectSetter(profile);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            Class<?> CraftSkullBlock = ReflectionUtils.getCraftClass("block.CraftSkull");
            Field field = CraftSkullBlock.getDeclaredField("profile");
            field.setAccessible(true);
            blockSetter = lookup.unreflectSetter(field);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!ReflectionUtils.supports(20, 2)) {
            try {
                propGetval = lookup.findVirtual(Property.class, "getValue", MethodType.methodType(String.class));
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        PROPERTY_GETVALUE = propGetval;
        CRAFT_META_SKULL_PROFILE_SETTER = profileSetter;
        CRAFT_META_SKULL_PROFILE_GETTER = profileGetter;
        CRAFT_META_SKULL_BLOCK_SETTER = blockSetter;
    }

    public static final class StringSkullCache {
        private final ValueType valueType;
        private final Object object;

        private StringSkullCache(ValueType valueType) {
            this(valueType, (Object)null);
        }

        private StringSkullCache(ValueType valueType, Object object) {
            this.valueType = valueType;
            this.object = object;
        }
    }

    public static enum ValueType {
        NAME,
        UUID,
        BASE64,
        TEXTURE_URL,
        TEXTURE_HASH,
        UNKNOWN;

    }
}

