/*
 * Decompiled with CFR 0.152.
 */
package fr.joschma.BlockParty.Arena;

import fr.joschma.BlockParty.Arena.State.ArenaState;
import fr.joschma.BlockParty.BPM;
import fr.joschma.BlockParty.Manager.FileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.block.Sign;
import org.bukkit.configuration.file.YamlConfiguration;

public class HubArena {
    BPM pl;
    String name;
    int maxPlayer;
    int currentPlayer;
    List<Sign> signs = new ArrayList<Sign>();
    File file;
    ArenaState state;
    List<String> signDisplay = new ArrayList<String>();

    public HubArena(BPM pl, String name, int maxPlayer, ArenaState state) {
        this.pl = pl;
        this.name = name;
        this.maxPlayer = maxPlayer;
        this.state = state;
        this.file = new File(pl.getDataFolder(), "HubArena" + File.separator + name + ".yml");
        this.signDisplay.add("\u00a7a[BlockParty]");
        this.signDisplay.add(name);
        this.signDisplay.add(this.currentPlayer + " / " + maxPlayer);
        this.setupFile();
    }

    private void setupFile() {
        if (!this.file.exists()) {
            FileManager.createFile(this.file);
            YamlConfiguration fc = FileManager.load(this.file);
            fc.set("SignDisplay", this.signDisplay);
            fc.set("Settings.MaxPlayer", (Object)this.maxPlayer);
            FileManager.save(this.file, fc);
        }
    }

    public void updateSign() {
        if (this.state != ArenaState.INGAME) {
            for (Sign sign : this.signs) {
                int y = 0;
                for (String str : this.signDisplay) {
                    sign.setLine(y, this.msg(str));
                    ++y;
                }
                sign.update();
            }
        } else {
            for (Sign sign : this.signs) {
                sign.setLine(2, ChatColor.RED + "In game !");
                sign.update();
            }
        }
    }

    public String msg(String message) {
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxPlayer() {
        return this.maxPlayer;
    }

    public List<Sign> getSigns() {
        return this.signs;
    }

    public BPM getPl() {
        return this.pl;
    }

    public File getFile() {
        return this.file;
    }

    public void setSigns(List<Sign> signs) {
        this.signs = signs;
    }

    public int getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(int currentPlayer) {
        this.currentPlayer = currentPlayer;
    }
}

