/*
 * Decompiled with CFR 0.152.
 */
package fr.joschma.BlockParty.Arena.Timer;

import com.cryptomorin.xseries.messages.ActionBar;
import fr.joschma.BlockParty.Arena.Arena;
import fr.joschma.BlockParty.Cuboid.DistributedFiller;
import fr.joschma.BlockParty.Cuboid.WorkloadRunnable;
import fr.joschma.BlockParty.Utils.RepeatUtils;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class RemoveFloorCountDown {
    double time;
    int taskID;
    double secondtracker;
    boolean hasToStop;
    DistributedFiller distributedFiller;
    WorkloadRunnable workloadRunnable;

    public void startCountDown(final Arena a) {
        this.distributedFiller = a.getDistributedFiller();
        this.workloadRunnable = a.getWorkloadRunnable();
        this.time = a.getRemoveFloorTime();
        final BukkitScheduler scheduler = Bukkit.getServer().getScheduler();
        this.hasToStop = false;
        this.taskID = scheduler.scheduleSyncRepeatingTask((Plugin)a.getPl(), new Runnable(){

            @Override
            public void run() {
                if (RemoveFloorCountDown.this.hasToStop) {
                    Bukkit.getScheduler().cancelTask(RemoveFloorCountDown.this.taskID);
                    scheduler.cancelTask(RemoveFloorCountDown.this.taskID);
                } else if (RemoveFloorCountDown.this.time <= 0.0) {
                    RemoveFloorCountDown.this.hasToStop = true;
                    for (Block bl : a.getDanceFloorCuboid().blockList()) {
                        if (bl.getType() == a.getDanceFloorActualMaterial() || a.getDanceFloorColourGroupActualMaterials().contains(bl.getType())) continue;
                        RemoveFloorCountDown.this.distributedFiller.fillLocation(bl.getLocation(), Material.AIR, RemoveFloorCountDown.this.workloadRunnable);
                        if (!a.isUseParticles()) continue;
                        RemoveFloorCountDown.this.spawnParticles(a, bl);
                    }
                    a.getRegenerateBlockTimer().startCountDown(a);
                    RemoveFloorCountDown.this.stopTimer();
                } else if (RemoveFloorCountDown.this.time > 0.0) {
                    if (RemoveFloorCountDown.this.secondtracker >= 1.0) {
                        for (Player p : a.getPlayersAlive()) {
                            if (!a.isGiveBlock() || a.isShowColorNameInBarTitle()) {
                                ActionBar.sendActionBar(p, RepeatUtils.rfcdMsg(p, a, (int)Math.floor(RemoveFloorCountDown.this.time), a.getDanceFloorActualMaterial().name()));
                            } else {
                                ActionBar.sendActionBar(p, RepeatUtils.rfcdBar(a, (int)Math.floor(RemoveFloorCountDown.this.time), a.getDanceFloorActualMaterial()));
                            }
                            if (RemoveFloorCountDown.this.time < 4.0 & RemoveFloorCountDown.this.time >= 3.0) {
                                p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 2.0f, 1.0f);
                                p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
                                continue;
                            }
                            if (RemoveFloorCountDown.this.time < 3.0 & RemoveFloorCountDown.this.time >= 2.0) {
                                p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 2.0f, 0.8f);
                                p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 0.8f);
                                continue;
                            }
                            if (RemoveFloorCountDown.this.time < 2.0 & RemoveFloorCountDown.this.time >= 1.0) {
                                p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 2.0f, 0.6f);
                                p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 0.6f);
                                continue;
                            }
                            if (!(RemoveFloorCountDown.this.time < 1.0 & RemoveFloorCountDown.this.time >= 0.0)) continue;
                            p.playSound(p.getLocation(), Sound.ENTITY_ENDER_DRAGON_FLAP, 2.0f, 1.5f);
                        }
                        RemoveFloorCountDown.this.secondtracker = 0.1;
                    } else {
                        RemoveFloorCountDown.this.secondtracker += 0.1;
                    }
                    RemoveFloorCountDown.this.time -= 0.1;
                }
            }
        }, 0L, 2L);
    }

    private void spawnParticles(Arena a, Block bl) {
        if (a.getParticle() == Particle.REDSTONE) {
            Particle.DustOptions dustOptions = null;
            Location particleLocation = bl.getLocation().clone().add(0.5, 0.0, 0.5);
            switch (a.getParticleColourSetting()) {
                case RANDOM: {
                    dustOptions = new Particle.DustOptions(RemoveFloorCountDown.randomColor(), a.getParticleSize().floatValue());
                    break;
                }
                case REMOVEBLOCKCOLOUR: {
                    dustOptions = new Particle.DustOptions(a.getPl().getColourUtils().getBlockColour(a, bl.getType()), a.getParticleSize().floatValue());
                    break;
                }
                case INHANDBLOCKCOLOUR: {
                    dustOptions = new Particle.DustOptions(a.getPl().getColourUtils().getBlockColour(a, a.getDanceFloorActualMaterial()), a.getParticleSize().floatValue());
                }
            }
            bl.getLocation().getWorld().spawnParticle(a.getParticle(), particleLocation, a.getParticleCount(), (Object)dustOptions);
        } else {
            bl.getLocation().getWorld().spawnParticle(a.getParticle(), bl.getLocation().clone().add(0.5, 0.0, 0.5), a.getParticleCount());
        }
    }

    public void stopTimer() {
        Bukkit.getScheduler().cancelTask(this.taskID);
        this.time = -1.0;
    }

    public static Color randomColor() {
        ThreadLocalRandom gen = ThreadLocalRandom.current();
        int randR = gen.nextInt(0, 256);
        int randG = gen.nextInt(0, 256);
        int randB = gen.nextInt(0, 256);
        return Color.fromRGB((int)randR, (int)randG, (int)randB);
    }
}

