/*
 * Decompiled with CFR 0.152.
 */
package fr.joschma.BlockParty.Listener;

import com.cryptomorin.xseries.XPotion;
import com.cryptomorin.xseries.XSound;
import fr.joschma.BlockParty.Arena.Arena;
import fr.joschma.BlockParty.Arena.State.ArenaState;
import fr.joschma.BlockParty.BPM;
import fr.joschma.BlockParty.Manager.ArenaManager;
import fr.joschma.BlockParty.Messages.Language;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class onPlayerMove
implements Listener {
    BPM pl;
    ArenaManager am;

    public onPlayerMove(BPM pl) {
        this.pl = pl;
        this.am = pl.getAm();
    }

    @EventHandler
    public void onPlayerMoveListenerPlayerExit(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        Arena a = this.am.getArenaPlayer(p);
        if (a != null && p.getGameMode() == a.getGmOnDeath() && !a.getArenaCuboid().isIn(p)) {
            p.teleport(a.getArenaCuboid().getCenter());
        }
    }

    @EventHandler
    public void onPlayerMoveListenerPlayerFall(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        Arena a = this.am.getArenaPlayer(p);
        if (a != null && a.getPlayersAlive().contains(p) && p.getLocation().getY() <= (double)a.getYLevelToDie()) {
            if (a.getState() == ArenaState.INGAME) {
                if (a.isEnableLightnings()) {
                    p.getWorld().spawnEntity(p.getLocation(), EntityType.LIGHTNING);
                }
                a.rmvAlivePlayer(p);
                String msg = ChatColor.YELLOW + e.getPlayer().getDisplayName() + ChatColor.GRAY + " \u27b2 " + Language.MSG.PlayerEliminatedMessage.msg();
                for (Player players : a.getPlayers()) {
                    this.pl.getDebug().msg(players, msg);
                }
                if (p.getGameMode() != GameMode.SPECTATOR) {
                    for (Player pla : a.getPlayers()) {
                        XSound.ENTITY_LIGHTNING_BOLT_IMPACT.play(pla.getLocation(), 2.0f, 1.0f);
                    }
                    String youHaveFinished = Language.MSG.YouHaveFinishedPlace.msg();
                    if (youHaveFinished.contains("%bpm_place%")) {
                        youHaveFinished = youHaveFinished.replace("%bpm_place%", String.valueOf(a.getPlayersAlive().size() + 1));
                    }
                    this.pl.getDebug().msg(p, youHaveFinished);
                    p.sendTitle(Language.MSG.YouDiedTitle.msg(), Language.MSG.YouDiedTitleSubtitle.msg(), 10, 60, 10);
                    p.setGameMode(a.getGmOnDeath());
                    if (a.getGmOnDeath() != GameMode.SPECTATOR) {
                        a.leaveGame(p);
                        return;
                    }
                    if (a.getArenaCuboid().isIn(a.getLobbySpawn())) {
                        p.teleport(a.getLobbySpawn());
                    } else {
                        p.teleport(a.getArenaCuboid().getCenter());
                    }
                    a.checkWin();
                }
            } else if (a.getState() == ArenaState.CLEARING) {
                if (a.getWinners().contains(p)) {
                    this.pl.getDebug().msg(p, Language.MSG.winnerFallOf.msg(p));
                    a.getStartGame().spawnPlayer(a, p);
                } else {
                    this.pl.getDebug().msg(p, Language.MSG.playerFallOfInClearing.msg(p));
                    p.teleport(a.getLobbySpawn());
                }
            }
        }
    }

    public void killPowerUp(Arena a, Player p) {
        double range = a.getRangeToCatchPowerup();
        Iterator iterator = p.getNearbyEntities(range, range, range).iterator();
        if (iterator.hasNext()) {
            Entity en = (Entity)iterator.next();
            if (en.getType() == EntityType.ARMOR_STAND) {
                if (en.getLocation().equals((Object)a.getPowerUpLoc())) {
                    en.remove();
                }
            } else if (a.isPowerUpAsBlock()) {
                a.getPowerUpLoc().getBlock().setType(Material.AIR);
            }
            a.setPowerUpLoc(null);
            return;
        }
    }

    @EventHandler
    public void onPlayerMoveListenerPowerUp(PlayerMoveEvent e) {
        final Player p = e.getPlayer();
        final Arena a = this.am.getArenaPlayer(p);
        if (a != null && p.getGameMode() != GameMode.SPECTATOR && a.getPowerUpLoc() != null) {
            double range = a.getRangeToCatchPowerup();
            for (Entity en : a.getPowerUpLoc().getWorld().getNearbyEntities(a.getPowerUpLoc(), range, range, range)) {
                int int_random;
                String powerUpName;
                if (en != p) continue;
                this.killPowerUp(a, p);
                Random rand = new Random();
                ArrayList<String> powerUps = new ArrayList<String>();
                powerUps.addAll(a.getPowerUps());
                if (a.isSoloGame() && powerUps.contains("Player Swap")) {
                    powerUps.remove("Player Swap");
                }
                if ((powerUpName = (String)powerUps.get(int_random = rand.nextInt(powerUps.size()))).equalsIgnoreCase("Speed")) {
                    a.clearPotionEffect(p);
                    p.addPotionEffect(new PotionEffect(XPotion.SPEED.getPotionEffectType(), 20 * a.getDurationPowerUp(), a.getLevelOfPowerUp() + 1));
                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)this.pl, new Runnable(){

                        @Override
                        public void run() {
                            p.addPotionEffect(new PotionEffect(XPotion.SPEED.getPotionEffectType(), Integer.MAX_VALUE, 0));
                        }
                    }, (long)(20 * a.getDurationPowerUp() + 1));
                    powerUpName = Language.MSG.PowerUpSpeed.msg();
                } else if (powerUpName.equalsIgnoreCase("Jump Boost")) {
                    p.addPotionEffect(new PotionEffect(XPotion.JUMP.getPotionEffectType(), 20 * a.getDurationPowerUp(), a.getLevelOfPowerUp()));
                    powerUpName = Language.MSG.PowerUpJump_Boost.msg();
                } else if (powerUpName.equalsIgnoreCase("Slow Falling")) {
                    p.addPotionEffect(new PotionEffect(XPotion.SLOW_FALLING.getPotionEffectType(), 20 * a.getDurationPowerUp(), a.getLevelOfPowerUp()));
                    powerUpName = Language.MSG.PowerUpSlow_Falling.msg();
                } else if (powerUpName.equalsIgnoreCase("Rain")) {
                    ItemStack rainItem = new ItemStack(Material.MAGMA_CREAM);
                    ItemMeta rainMeta = rainItem.getItemMeta();
                    rainMeta.setDisplayName(Language.MSG.ColourRainItemName.msg());
                    rainItem.setItemMeta(rainMeta);
                    p.getInventory().addItem(new ItemStack[]{rainItem});
                    powerUpName = Language.MSG.PowerUpRain.msg();
                } else if (powerUpName.equalsIgnoreCase("Leap")) {
                    ItemStack leapItem = new ItemStack(Material.FEATHER);
                    ItemMeta leapMeta = leapItem.getItemMeta();
                    leapMeta.setDisplayName(Language.MSG.LeapItemName.msg());
                    leapItem.setItemMeta(leapMeta);
                    p.getInventory().addItem(new ItemStack[]{leapItem});
                    powerUpName = Language.MSG.PowerUpLeap.msg();
                } else if (powerUpName.equalsIgnoreCase("Random Teleport")) {
                    powerUpName = Language.MSG.PowerUpRandomTP.msg();
                    Location loc = a.getDanceFloorCuboid().getRandomLocation().add(0.0, 2.0, 0.0);
                    p.teleport(loc);
                } else if (powerUpName.equalsIgnoreCase("Cow")) {
                    final Material ma = a.getDanceFloorActualMaterial();
                    Location loc = p.getLocation();
                    final Cow cow = (Cow)p.getWorld().spawnEntity(loc, EntityType.COW);
                    cow.setCustomName(Language.MSG.CowName.msg());
                    cow.setCustomNameVisible(true);
                    powerUpName = Language.MSG.CowName.msg();
                    Bukkit.getServer().getScheduler().runTaskLater((Plugin)this.pl, new Runnable(){

                        @Override
                        public void run() {
                            cow.getWorld().createExplosion(cow.getLocation(), 0.0f, false);
                            cow.remove();
                            int cowX = cow.getLocation().getBlockX();
                            int cowZ = cow.getLocation().getBlockZ();
                            int cowY = cow.getLocation().getBlockY() - 1;
                            for (int x = cowX - 2; x <= cowX + 2; ++x) {
                                for (int z = cowZ - 2; z <= cowZ + 2; ++z) {
                                    Location loc = new Location(p.getWorld(), (double)x, (double)cowY, (double)z);
                                    if (loc.getBlock().getType() == Material.AIR || !a.getDanceFloorCuboid().isIn(loc)) continue;
                                    loc.getBlock().setType(ma);
                                }
                            }
                        }
                    }, 41L);
                } else if (powerUpName.equalsIgnoreCase("Night Vision")) {
                    powerUpName = Language.MSG.PowerUpNightVision.msg();
                    p.addPotionEffect(new PotionEffect(XPotion.NIGHT_VISION.getPotionEffectType(), 20 * a.getDurationPowerUp(), a.getLevelOfPowerUp()));
                } else if (powerUpName.equalsIgnoreCase("Player Swap")) {
                    powerUpName = Language.MSG.PowerUpPlayerSwap.msg();
                    Random randPlay = new Random();
                    Player toSwap = a.getPlayers().get(randPlay.nextInt(a.getPlayers().size()));
                    Location locToSwap = toSwap.getLocation();
                    toSwap.teleport(p.getLocation());
                    p.teleport(locToSwap);
                }
                String msg = Language.MSG.gotPowerUp.msg().replace("%bpm_power_up%", ChatColor.GOLD + powerUpName + ChatColor.GRAY);
                this.pl.getDebug().msg(p, msg);
                XSound.ENTITY_SILVERFISH_DEATH.play(p.getLocation(), 3.0f, 0.5f);
                String msg2 = Language.MSG.PowerUpCollector.msg().replace("%player_name%", p.getName());
                for (Player p2 : a.getPlayers()) {
                    if (p2 == p) continue;
                    this.pl.getDebug().msg(p2, msg2);
                }
            }
        }
    }
}

