/*
 * Decompiled with CFR 0.152.
 */
package fr.joschma.BlockParty.Cuboid;

import fr.joschma.BlockParty.Arena.Arena;
import fr.joschma.BlockParty.Cuboid.PlacableBlock;
import java.util.ArrayDeque;
import java.util.Deque;

public class WorkloadRunnable
implements Runnable {
    private static double MAX_MILLIS_PER_TICK = 2.5;
    private static final int MAX_NANOS_PER_TICK = (int)(MAX_MILLIS_PER_TICK * 1000000.0);
    public Deque<PlacableBlock> workloadDeque = new ArrayDeque<PlacableBlock>();
    Arena a;

    public WorkloadRunnable(Arena a) {
        MAX_MILLIS_PER_TICK = a.getMaxMillisSecondPerTickToGenerateArenaDanceFloor();
        this.a = a;
    }

    public void addWorkload(PlacableBlock workload) {
        this.workloadDeque.add(workload);
    }

    @Override
    public void run() {
        PlacableBlock nextLoad;
        long stopTime = System.nanoTime() + (long)MAX_NANOS_PER_TICK;
        while (System.nanoTime() <= stopTime && (nextLoad = this.workloadDeque.poll()) != null) {
            nextLoad.compute();
        }
    }
}

