/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class ReflectionUtils {
    @Nullable
    public static final String NMS_VERSION = ReflectionUtils.findNMSVersionString();
    public static final int MAJOR_NUMBER;
    public static final int MINOR_NUMBER;
    public static final int PATCH_NUMBER;
    public static final String CRAFTBUKKIT_PACKAGE;
    public static final String NMS_PACKAGE;
    private static final MethodHandle PLAYER_CONNECTION;
    private static final MethodHandle GET_HANDLE;
    private static final MethodHandle SEND_PACKET;

    @Nullable
    public static String findNMSVersionString() {
        String found = null;
        for (Package pack : Package.getPackages()) {
            String name = pack.getName();
            if (!name.startsWith("org.bukkit.craftbukkit.v")) continue;
            found = pack.getName().split("\\.")[3];
            try {
                Class.forName("org.bukkit.craftbukkit." + found + ".entity.CraftPlayer");
                break;
            }
            catch (ClassNotFoundException e) {
                found = null;
            }
        }
        return found;
    }

    public static String getVersionInformation() {
        return "(NMS: " + NMS_VERSION + " | Parsed: " + MAJOR_NUMBER + '.' + MINOR_NUMBER + '.' + PATCH_NUMBER + " | Minecraft: " + Bukkit.getVersion() + " | Bukkit: " + Bukkit.getBukkitVersion() + ')';
    }

    public static Integer getLatestPatchNumberOf(int minorVersion) {
        if (minorVersion <= 0) {
            throw new IllegalArgumentException("Minor version must be positive: " + minorVersion);
        }
        int[] patches = new int[]{1, 5, 2, 7, 2, 4, 10, 8, 4, 2, 2, 2, 2, 4, 2, 5, 1, 2, 4, 4};
        if (minorVersion > patches.length) {
            return null;
        }
        return patches[minorVersion - 1];
    }

    private ReflectionUtils() {
    }

    public static <T> VersionHandler<T> v(int version, T handle) {
        return new VersionHandler(version, handle);
    }

    public static <T> VersionHandler<T> v(int version, int patch, T handle) {
        return new VersionHandler(version, patch, handle);
    }

    public static <T> CallableVersionHandler<T> v(int version, Callable<T> handle) {
        return new CallableVersionHandler(version, handle);
    }

    public static boolean supports(int minorNumber) {
        return MINOR_NUMBER >= minorNumber;
    }

    public static boolean supports(int minorNumber, int patchNumber) {
        return MINOR_NUMBER == minorNumber ? ReflectionUtils.supportsPatch(patchNumber) : ReflectionUtils.supports(minorNumber);
    }

    public static boolean supportsPatch(int patchNumber) {
        return PATCH_NUMBER >= patchNumber;
    }

    @Nonnull
    public static Class<?> getNMSClass(@Nullable String packageName, @Nonnull String name) {
        if (packageName != null && ReflectionUtils.supports(17)) {
            name = packageName + '.' + name;
        }
        try {
            return Class.forName(NMS_PACKAGE + name);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nonnull
    public static Class<?> getNMSClass(@Nonnull String name) {
        return ReflectionUtils.getNMSClass(null, name);
    }

    @Nonnull
    public static CompletableFuture<Void> sendPacket(@Nonnull Player player, Object ... packets) {
        return CompletableFuture.runAsync(() -> ReflectionUtils.sendPacketSync(player, packets)).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public static void sendPacketSync(@Nonnull Player player, Object ... packets) {
        try {
            Object handle = GET_HANDLE.invoke(player);
            Object connection = PLAYER_CONNECTION.invoke(handle);
            if (connection != null) {
                for (Object packet : packets) {
                    SEND_PACKET.invoke(connection, packet);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Nullable
    public static Object getHandle(@Nonnull Player player) {
        Objects.requireNonNull(player, "Cannot get handle of null player");
        try {
            return GET_HANDLE.invoke(player);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Object getConnection(@Nonnull Player player) {
        Objects.requireNonNull(player, "Cannot get connection of null player");
        try {
            Object handle = GET_HANDLE.invoke(player);
            return PLAYER_CONNECTION.invoke(handle);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Nonnull
    public static Class<?> getCraftClass(@Nonnull String name) {
        try {
            return Class.forName(CRAFTBUKKIT_PACKAGE + '.' + name);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nonnull
    public static Class<?> toArrayClass(Class<?> clazz) {
        try {
            return Class.forName("[L" + clazz.getName() + ';');
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Cannot find array class for class: " + clazz, ex);
        }
    }

    static {
        Matcher bukkitVer = Pattern.compile("^(?<major>\\d+)\\.(?<minor>\\d+)\\.(?<patch>\\d+)?").matcher(Bukkit.getBukkitVersion());
        if (bukkitVer.find()) {
            try {
                String patch = bukkitVer.group("patch");
                MAJOR_NUMBER = Integer.parseInt(bukkitVer.group("major"));
                MINOR_NUMBER = Integer.parseInt(bukkitVer.group("minor"));
                PATCH_NUMBER = Integer.parseInt(patch == null || patch.isEmpty() ? "0" : patch);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Failed to parse minor number: " + bukkitVer + ' ' + ReflectionUtils.getVersionInformation(), ex);
            }
        } else {
            throw new IllegalStateException("Cannot parse server version: \"" + Bukkit.getBukkitVersion() + '\"');
        }
        CRAFTBUKKIT_PACKAGE = Bukkit.getServer().getClass().getPackage().getName();
        NMS_PACKAGE = ReflectionUtils.v(17, "net.minecraft.").orElse("net.minecraft.server." + NMS_VERSION + '.');
        Class<?> entityPlayer = ReflectionUtils.getNMSClass("server.level", "EntityPlayer");
        Class<?> craftPlayer = ReflectionUtils.getCraftClass("entity.CraftPlayer");
        Class<?> playerConnection = ReflectionUtils.getNMSClass("server.network", "PlayerConnection");
        Class<?> playerCommonConnection = ReflectionUtils.supports(20) && ReflectionUtils.supportsPatch(2) ? ReflectionUtils.getNMSClass("server.network", "ServerCommonPacketListenerImpl") : playerConnection;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle sendPacket = null;
        MethodHandle getHandle = null;
        MethodHandle connection = null;
        try {
            connection = lookup.findGetter(entityPlayer, ReflectionUtils.v(20, "c").v(17, "b").orElse("playerConnection"), playerConnection);
            getHandle = lookup.findVirtual(craftPlayer, "getHandle", MethodType.methodType(entityPlayer));
            sendPacket = lookup.findVirtual(playerCommonConnection, ReflectionUtils.v(20, 2, "b").v(18, "a").orElse("sendPacket"), MethodType.methodType(Void.TYPE, ReflectionUtils.getNMSClass("network.protocol", "Packet")));
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        PLAYER_CONNECTION = connection;
        SEND_PACKET = sendPacket;
        GET_HANDLE = getHandle;
    }

    public static final class VersionHandler<T> {
        private int version;
        private int patch;
        private T handle;

        private VersionHandler(int version, T handle) {
            this(version, 0, handle);
        }

        private VersionHandler(int version, int patch, T handle) {
            if (ReflectionUtils.supports(version) && ReflectionUtils.supportsPatch(patch)) {
                this.version = version;
                this.patch = patch;
                this.handle = handle;
            }
        }

        public VersionHandler<T> v(int version, T handle) {
            return this.v(version, 0, handle);
        }

        public VersionHandler<T> v(int version, int patch, T handle) {
            if (version == this.version && patch == this.patch) {
                throw new IllegalArgumentException("Cannot have duplicate version handles for version: " + version + '.' + patch);
            }
            if (version > this.version && ReflectionUtils.supports(version) && patch >= this.patch && ReflectionUtils.supportsPatch(patch)) {
                this.version = version;
                this.patch = patch;
                this.handle = handle;
            }
            return this;
        }

        public T orElse(T handle) {
            return this.version == 0 ? handle : this.handle;
        }
    }

    public static final class CallableVersionHandler<T> {
        private int version;
        private Callable<T> handle;

        private CallableVersionHandler(int version, Callable<T> handle) {
            if (ReflectionUtils.supports(version)) {
                this.version = version;
                this.handle = handle;
            }
        }

        public CallableVersionHandler<T> v(int version, Callable<T> handle) {
            if (version == this.version) {
                throw new IllegalArgumentException("Cannot have duplicate version handles for version: " + version);
            }
            if (version > this.version && ReflectionUtils.supports(version)) {
                this.version = version;
                this.handle = handle;
            }
            return this;
        }

        public T orElse(Callable<T> handle) {
            try {
                return (this.version == 0 ? handle : this.handle).call();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

