/*
 * Decompiled with CFR 0.152.
 */
package fr.joschma.BlockParty;

import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import fr.joschma.BlockParty.Arena.Arena;
import fr.joschma.BlockParty.Arena.InitializeArena;
import fr.joschma.BlockParty.Arena.State.SongProvider;
import fr.joschma.BlockParty.Gui.ArenaGui;
import fr.joschma.BlockParty.Gui.ChoseSongGUI;
import fr.joschma.BlockParty.Gui.JoinArenaGui;
import fr.joschma.BlockParty.Listener.FoodLevelChangeListener;
import fr.joschma.BlockParty.Listener.onPlayerArmorStandManipulateListener;
import fr.joschma.BlockParty.Listener.onPlayerBreakBlock;
import fr.joschma.BlockParty.Listener.onPlayerChat;
import fr.joschma.BlockParty.Listener.onPlayerClickInventory;
import fr.joschma.BlockParty.Listener.onPlayerCommand;
import fr.joschma.BlockParty.Listener.onPlayerDropItem;
import fr.joschma.BlockParty.Listener.onPlayerInteract;
import fr.joschma.BlockParty.Listener.onPlayerJoin;
import fr.joschma.BlockParty.Listener.onPlayerLeave;
import fr.joschma.BlockParty.Listener.onPlayerMove;
import fr.joschma.BlockParty.Listener.onPlayerPlaceBlock;
import fr.joschma.BlockParty.Listener.onPlayerSwapHandItemsListener;
import fr.joschma.BlockParty.Listener.onPlayerTakeDamage;
import fr.joschma.BlockParty.Listener.onPluginMessageListener;
import fr.joschma.BlockParty.Listener.onServerListPingEvent;
import fr.joschma.BlockParty.Listener.onSnowballLand;
import fr.joschma.BlockParty.Manager.ArenaManager;
import fr.joschma.BlockParty.Manager.CommandManager;
import fr.joschma.BlockParty.Manager.CustomDanceFloorManager;
import fr.joschma.BlockParty.Manager.ExpansionManager;
import fr.joschma.BlockParty.Manager.FileManager;
import fr.joschma.BlockParty.Manager.InventoryManager;
import fr.joschma.BlockParty.Manager.JustJoinedManager;
import fr.joschma.BlockParty.Manager.LeaderboardManager;
import fr.joschma.BlockParty.Manager.MusicManager;
import fr.joschma.BlockParty.Manager.PlayerHiderManager;
import fr.joschma.BlockParty.Manager.TextToAddToCommandManager;
import fr.joschma.BlockParty.Messages.Debugger;
import fr.joschma.BlockParty.TabFinisher.TabCompletor;
import fr.joschma.BlockParty.Utils.ColourUtils;
import fr.joschma.BlockParty.Utils.CustomHeadUtils;
import fr.joschma.BlockParty.Utils.ScoreBoardUtils;
import fr.joschma.BlockParty.Utils.UtilsConfig;
import fr.joschma.BlockParty.Utils.UtilsPrefix;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BPM
extends JavaPlugin {
    public String uid = "%%__USER__%%";
    public boolean sts = true;
    final int version;
    boolean hubServer;
    boolean firstPlayerJoined = true;
    boolean noteIsEnable;
    boolean partiesIsEnable;
    boolean placeholderIsEnable;
    boolean MCJukeboxIsEnable;
    boolean OpenAudioMcIsEnable;
    ScoreBoardUtils scoreBoardUtils;
    UtilsPrefix utilsPrefix;
    Debugger debug;
    InitializeArena initializeArena;
    ArenaGui arenaGui;
    ChoseSongGUI choseSongGUI;
    JoinArenaGui joinArenaGui;
    ArenaManager am;
    MusicManager musicManager;
    InventoryManager invManager;
    LeaderboardManager leaderboardManager;
    PlayerHiderManager playerHiderManager;
    TextToAddToCommandManager textToAddToCommandManager;
    CustomDanceFloorManager customDanceFloorManager;
    JustJoinedManager justJoinedManager;
    ExpansionManager expansionManager;
    CustomHeadUtils customHeadUtils;
    List<String> colourName = new ArrayList<String>();
    ColourUtils colourUtils;
    static BPM pl;

    public BPM() {
        String packet = Bukkit.getServer().getClass().getPackage().getName();
        String[] parts = packet.replace(".", ",").split(",");
        if (parts.length > 3) {
            String versionPart = parts[3];
            String[] versionSplit = versionPart.split("_");
            if (versionSplit.length > 1) {
                this.version = Integer.parseInt(versionSplit[1]);
            } else {
                this.version = -1;
                Bukkit.getLogger().warning("Could not parse version from package name: " + packet);
            }
        } else {
            this.version = -1;
            Bukkit.getLogger().warning("Unexpected package structure: " + packet);
        }
        this.noteIsEnable = true;
        this.OpenAudioMcIsEnable = true;
        this.MCJukeboxIsEnable = true;
        this.partiesIsEnable = false;
        this.utilsPrefix = new UtilsPrefix(this);
        this.debug = new Debugger(this);
        this.initializeArena = new InitializeArena(this);
        this.arenaGui = new ArenaGui();
        this.choseSongGUI = new ChoseSongGUI(this);
        this.joinArenaGui = new JoinArenaGui(this);
        this.am = new ArenaManager();
        this.musicManager = new MusicManager();
        this.invManager = new InventoryManager();
        this.scoreBoardUtils = new ScoreBoardUtils();
        this.leaderboardManager = new LeaderboardManager();
        this.playerHiderManager = new PlayerHiderManager(this);
        this.textToAddToCommandManager = new TextToAddToCommandManager();
        this.customDanceFloorManager = new CustomDanceFloorManager();
        this.justJoinedManager = new JustJoinedManager();
        this.customHeadUtils = new CustomHeadUtils();
        this.colourUtils = new ColourUtils();
        this.colourName.addAll(Arrays.asList("red", "gold", "yellow", "green", "aqua", "blue", "purple", "white", "gray", "black"));
    }

    public void onEnable() {
        File customDanceFloorFolder;
        File songsFolder;
        if (this.getConfig().getBoolean("useBungeeCord")) {
            this.bungee();
        }
        pl = this;
        pl.saveDefaultConfig();
        if (!new File(this.getDataFolder(), "Language.yml").exists()) {
            this.saveResource("Language.yml", false);
        }
        if (!new File(this.getDataFolder(), "Leaderboard.yml").exists()) {
            this.saveResource("Leaderboard.yml", false);
        }
        if (!(songsFolder = new File(this.getDataFolder(), "Songs")).exists()) {
            songsFolder.mkdirs();
        }
        if (!(customDanceFloorFolder = new File(this.getDataFolder(), "CustomDanceFloors")).exists()) {
            customDanceFloorFolder.mkdirs();
        }
        if (!new File(this.getDataFolder(), "ColourLanguage.yml").exists()) {
            this.saveResource("ColourLanguage.yml", false);
        }
        if (!new File(this.getDataFolder() + File.separator + "Songs", "RealThing.nbs").exists()) {
            this.saveResource("Songs" + File.separator + "RealThing.nbs", false);
        }
        if (!new File(this.getDataFolder() + File.separator + "Songs", "nothing.nbs").exists()) {
            this.saveResource("Songs" + File.separator + "nothing.nbs", false);
        }
        if (!new File(this.getDataFolder(), "Leaderboard.yml").exists()) {
            this.saveResource("Leaderboard.yml", false);
        }
        if (Bukkit.getPluginManager().isPluginEnabled("Multiverse-Core")) {
            MultiverseCore core = (MultiverseCore)Bukkit.getServer().getPluginManager().getPlugin("Multiverse-Core");
            MVWorldManager mVWorldManager = core.getMVWorldManager();
        }
        this.initializeCustomDanceFloor();
        this.initializeArenaNames();
        this.initializeArena.initializeArena();
        String version = this.getDescription().getVersion();
        if (version.split("\\.").length == 2 && this.getConfig().getDouble("LastVersion") != Double.valueOf(version).doubleValue()) {
            new UtilsConfig(this).update();
        }
        this.registerEvents();
        this.registerCommand("blockparty", this.getConfig().getStringList("Aliases"), new CommandManager(this), new TabCompletor(this));
        if (this.getConfig().getBoolean("useBungeeCord")) {
            this.checkIfBungee();
        }
        this.isPluginActivated();
        this.checkSongProvider();
        if (this.getServer().getPluginManager().getPlugin("Parties") != null && this.getServer().getPluginManager().getPlugin("Parties").isEnabled()) {
            this.partiesIsEnable = true;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.placeholderIsEnable = true;
            this.expansionManager = new ExpansionManager(this);
            this.expansionManager.register();
        } else {
            this.debug.broadcastError("Could not load BlockParty you need to download PlaceholderAPI");
            this.debug.broadcastError("https://www.spigotmc.org/resources/placeholderapi.6245/");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        this.initializeLeaderBoard();
        super.onEnable();
    }

    public void setUpHubServer() {
        for (Arena a : this.am.getArenas()) {
            a.urgentLeaveGame();
        }
        this.am.getArenas().clear();
    }

    private void bungee() {
        if (this.getConfig().getString("ServerName") == null) {
            this.getConfig().set("ServerName", (Object)"blockpartyserver");
            this.saveConfig();
        }
        onPluginMessageListener pluginMessageListener = new onPluginMessageListener(this);
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)pluginMessageListener);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "joschma:blockparty" + this.getConfig().getString("ServerName").toLowerCase(), (PluginMessageListener)pluginMessageListener);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "joschma:blockparty");
    }

    private void checkSongProvider() {
        for (Arena a : this.am.getArenas()) {
            if (a.getSongProvider() == SongProvider.NoteBlock) {
                if (this.noteIsEnable) continue;
                this.debug.broadcastError(" *** NoteBlockAPI is not installed or not enabled. ***");
                this.debug.broadcastError("https://www.spigotmc.org/resources/noteblockapi.19287/");
                continue;
            }
            if (a.getSongProvider() == SongProvider.MCJukebox) {
                if (this.MCJukeboxIsEnable) continue;
                this.debug.broadcastError(" *** MCJukebox is not installed or not enabled. ***");
                this.debug.broadcastError("https://www.spigotmc.org/resources/mcjukebox.16024/");
                continue;
            }
            if (a.getSongProvider() != SongProvider.OpenAudioMC || this.OpenAudioMcIsEnable) continue;
            this.debug.broadcastError(" *** OpenAudio is not installed or not enabled. ***");
            this.debug.broadcastError("https://www.spigotmc.org/resources/openaudiomc-proximity-voice-chat-and-music-without-mods.30691/");
        }
    }

    private void isPluginActivated() {
        if (!Bukkit.getPluginManager().isPluginEnabled("PlaceHolderAPI")) {
            this.placeholderIsEnable = false;
        }
        if (!Bukkit.getPluginManager().isPluginEnabled("NoteBlockAPI")) {
            this.noteIsEnable = false;
        }
        if (!Bukkit.getPluginManager().isPluginEnabled("MCJukebox")) {
            this.MCJukeboxIsEnable = false;
        }
        if (!Bukkit.getPluginManager().isPluginEnabled("OpenAudioMc")) {
            this.OpenAudioMcIsEnable = false;
        }
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new onServerListPingEvent(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new onPlayerSwapHandItemsListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new onPlayerChat(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new onPlayerInteract(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new onPlayerMove(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new onPlayerLeave(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new onPlayerPlaceBlock(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new onPlayerTakeDamage(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new onPlayerDropItem(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new onPlayerCommand(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new onPlayerBreakBlock(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FoodLevelChangeListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new onPlayerClickInventory(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new onPlayerArmorStandManipulateListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new onSnowballLand(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new onPlayerJoin(this), (Plugin)this);
    }

    private void checkIfBungee() {
        if (!this.getServer().spigot().getConfig().getConfigurationSection("settings").getBoolean("bungeecord")) {
            this.debug.broadcastError("You have set bungee setting to true");
            this.debug.broadcastError("But no bungeecord has been detected");
        }
    }

    private void initializeCustomDanceFloor() {
        File folder = new File(this.getDataFolder() + File.separator + "CustomDanceFloors");
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (!listOfFiles[i].isFile()) continue;
                YamlConfiguration fcCustomDanceFloor = YamlConfiguration.loadConfiguration((File)listOfFiles[i]);
                ArrayList<Material> mas = new ArrayList<Material>();
                for (String materialName : fcCustomDanceFloor.getStringList("Material")) {
                    mas.add(Material.valueOf((String)materialName));
                }
                this.customDanceFloorManager.getCustomDanceFloor().put(listOfFiles[i].getName().replace(".yml", ""), mas);
            }
        }
    }

    private void initializeLeaderBoard() {
        if (!new File(this.getDataFolder(), "Leaderboard").exists()) {
            FileManager.createFile("Leaderboard");
        }
        File leaderboard = FileManager.load("Leaderboard");
        YamlConfiguration fc = FileManager.load(leaderboard);
        for (String uuid : fc.getConfigurationSection("").getKeys(false)) {
            String pName = fc.getString(uuid + ".name");
            int games = fc.getInt(uuid + ".game");
            pl.getLeaderboardManager().getGameMap().put(pName, games);
            int wins = fc.getInt(uuid + ".win");
            pl.getLeaderboardManager().getWinMap().put(pName, wins);
            pl.getLeaderboardManager().getLooseMap().put(pName, games - wins);
        }
    }

    public void onDisable() {
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this);
        for (Arena a : this.am.getArenas()) {
            a.urgentLeaveGame();
        }
        for (Arena a : this.am.getArenas()) {
            this.initializeArena.saveArena(a);
        }
        pl = null;
        super.onDisable();
    }

    public boolean isNumeric(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void initializeArenaNames() {
        File folder = new File(this.getDataFolder() + File.separator + "Arenas");
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (!listOfFiles[i].isFile()) continue;
                this.am.addArenaNames(listOfFiles[i].getName().replace(".yml", ""));
            }
        }
    }

    public <K, V> K getKey(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String msg(Player p, String message) {
        String msg = message;
        Arena a = BPM.getPl().getAm().getArenaPlayer(Bukkit.getPlayer((UUID)p.getUniqueId()));
        msg = ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
        if (a == null) {
            return msg;
        }
        if (BPM.getPl().isPlaceholderIsEnable()) {
            return PlaceholderAPI.setPlaceholders((Player)p, (String)msg);
        }
        return msg;
    }

    public void registerCommand(String cmd, List<String> aliases, CommandExecutor executor, TabCompletor tab) {
        PluginCommand plc = null;
        Class<PluginCommand> cl = PluginCommand.class;
        Constructor cons = null;
        try {
            cons = cl.getDeclaredConstructor(String.class, Plugin.class);
            cons.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e1) {
            e1.printStackTrace();
        }
        try {
            plc = (PluginCommand)cons.newInstance(new Object[]{cmd, this});
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        if (plc == null) {
            this.debug.broadcastError("Problem when initialize commands!");
            return;
        }
        plc.setAliases(aliases);
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            commandMap.register(cmd, (Command)plc);
            plc.register(commandMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        plc.setPermission("BlockParty.Player");
        plc.setTabCompleter((TabCompleter)tab);
        plc.setExecutor(executor);
    }

    public void sendCustomData(Player player, String subChannel, String ... datas) {
        if (this.getServer().getOnlinePlayers() == null || this.getServer().getOnlinePlayers().isEmpty()) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(subChannel);
        for (String data : datas) {
            out.writeUTF(data);
        }
        player.getServer().sendPluginMessage((Plugin)this, "joschma:blockparty", out.toByteArray());
    }

    public void sendBungeeCustomData(String subChannel, String ... datas) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(subChannel);
        for (String data : datas) {
            out.writeUTF(data);
        }
        Player player = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        player.sendPluginMessage((Plugin)this, "BungeeCord", out.toByteArray());
    }

    public PlayerHiderManager getPlayerHiderManager() {
        return this.playerHiderManager;
    }

    public LeaderboardManager getLeaderboardManager() {
        return this.leaderboardManager;
    }

    public TextToAddToCommandManager getTextToAddToCommandManager() {
        return this.textToAddToCommandManager;
    }

    public boolean isPlaceholderIsEnable() {
        return this.placeholderIsEnable;
    }

    public ChoseSongGUI getChoseSongGUI() {
        return this.choseSongGUI;
    }

    public boolean isPartiesIsEnable() {
        return this.partiesIsEnable;
    }

    public InventoryManager getInvManager() {
        return this.invManager;
    }

    public MusicManager getMusicManager() {
        return this.musicManager;
    }

    public ArenaManager getAm() {
        return this.am;
    }

    public ArenaGui getArenaGui() {
        return this.arenaGui;
    }

    public InitializeArena getInitializeArena() {
        return this.initializeArena;
    }

    public boolean isNoteIsEnable() {
        return this.noteIsEnable;
    }

    public boolean isMCJukeboxIsEnable() {
        return this.MCJukeboxIsEnable;
    }

    public static BPM getPl() {
        return pl;
    }

    public Debugger getDebug() {
        return this.debug;
    }

    public UtilsPrefix getUtilsPrefix() {
        return this.utilsPrefix;
    }

    public ScoreBoardUtils getScoreBoardUtils() {
        return this.scoreBoardUtils;
    }

    public int getVersion() {
        return this.version;
    }

    public CustomDanceFloorManager getCustomDanceFloorManager() {
        return this.customDanceFloorManager;
    }

    public JoinArenaGui getJoinArenaGui() {
        return this.joinArenaGui;
    }

    public JustJoinedManager getJustJoinedManager() {
        return this.justJoinedManager;
    }

    public ExpansionManager getExpansionManager() {
        return this.expansionManager;
    }

    public CustomHeadUtils getCustomHeadUtils() {
        return this.customHeadUtils;
    }

    public List<String> getColourName() {
        return this.colourName;
    }

    public ColourUtils getColourUtils() {
        return this.colourUtils;
    }

    public boolean isFirstPlayerJoined() {
        return this.firstPlayerJoined;
    }

    public void setFirstPlayerJoined(boolean firstPlayerJoined) {
        this.firstPlayerJoined = firstPlayerJoined;
    }

    public boolean isHubServer() {
        return this.hubServer;
    }

    public void setHubServer(boolean hubServer) {
        this.hubServer = hubServer;
    }
}

